
import Layout from '@/views/layout/Layout'

const dockersRouter = {
  path: '/dockers',
  component: Layout,
  redirect: 'noredirect',
  name: 'Dockers',
  meta: {
    title: 'Dockers',
    icon: 'chart'
  },
  children: [
    {
      path: 'runingEnvTest',
      component: () => import('@/views/docker/runingEnvTest'),
      name: 'RuningEnvTest',
      meta: { title: '测试环境', noCache: true, roles: ['test'] }
    },
    {
      path: 'runingEnvDev',
      component: () => import('@/views/docker/runingEnvDev'),
      name: 'RuningEnvDev',
      meta: { title: '开发环境', noCache: true, roles: ['dev'] }
    },
    // {
    //   path: 'hangUpEnv',
    //   component: () => import('@/views/docker/hangUpEnv'),
    //   name: 'HangUpEnv',
    //   meta: { title: 'hangUpEnv', noCache: true }
    // },
    {
      path: 'createEnv',
      component: () => import('@/views/docker/createEnv'),
      name: 'CreateEnv',
      meta: { title: 'createEnv', noCache: true, roles: ['admin'] }
    },
    {
      path: 'envTemplate',
      component: () => import('@/views/docker/envTemplate'),
      name: 'EnvTemplate',
      meta: { title: 'envTemplate', noCache: true }
    },
    {
      path: 'runingEnv/:name',
      component: () => import('@/views/docker/envDetail'),
      name: 'Detail',
      meta: { title: 'detail', noCache: true },
      hidden: true
    },
    {
      path: 'deployEnv/:name',
      component: () => import('@/views/docker/deployEnv'),
      name: 'deploy',
      meta: { title: '部署应用服务', noCache: true },
      hidden: true
    },
    {
      path: 'syncMq/:name',
      component: () => import('@/views/docker/syncMq'),
      name: 'syncMq',
      meta: { title: '同步MQ', noCache: true },
      hidden: true
    },
    {
      path: 'cluster',
      component: () => import('@/views/cluster/cluster'),
      name: '设置集群',
      meta: { title: '集群设置', roles: ['admin'] }
    }
  ]
}

export default dockersRouter
