import request from '@/utils/request'

export function getConfig(query) {
  return request({
    url: '/dbconfig/get_db_config',
    method: 'get',
    params: query
  })
}

export function saveConfig(data) {
  return request({
    url: '/dbconfig/save',
    method: 'post',
    data
  })
}

export function deleteConfig(query) {
  return request({
    url: '/dbconfig/delete',
    method: 'get',
    params: query
  })
}

export function getNamespaceTke(query) {
  return request({
    url: '/k8s/namespace',
    method: 'get',
    params: query
  })
}

export function getNamespace(query) {
  return request({
    url: '/dbsync/get_name_space',
    method: 'get',
    params: query
  })
}

export function getDBName(query) {
  return request({
    url: '/dbsync/get_dbs',
    method: 'get',
    params: query
  })
}

export function dbSyncTke(data) {
  return request({
    url: '/dbsync/tke',
    method: 'post',
    data
  })
}

export function dbSync(data) {
  return request({
    url: '/dbsync/db_sync',
    method: 'post',
    data
  })
}

export function dbSyncQuery(data) {
  return request({
    url: '/dbsync/db_sync_query',
    method: 'post',
    data
  })
}
