// set function parseTime,formatTime to filter
export { parseTime, formatTime } from '@/utils'

function pluralize(time, label) {
  if (time === 1) {
    return time + label
  }
  return time + label + 's'
}

export function timeAgo(time) {
  const between = Date.now() / 1000 - Number(time)
  if (between < 3600) {
    return pluralize(~~(between / 60), ' minute')
  } else if (between < 86400) {
    return pluralize(~~(between / 3600), ' hour')
  } else {
    return pluralize(~~(between / 86400), ' day')
  }
}

/* 数字 格式化*/
export function numberFormatter(num, digits) {
  const si = [
    { value: 1E18, symbol: 'E' },
    { value: 1E15, symbol: 'P' },
    { value: 1E12, symbol: 'T' },
    { value: 1E9, symbol: 'G' },
    { value: 1E6, symbol: 'M' },
    { value: 1E3, symbol: 'k' }
  ]
  for (let i = 0; i < si.length; i++) {
    if (num >= si[i].value) {
      return (num / si[i].value + 0.1).toFixed(digits).replace(/\.0+$|(\.[0-9]*[1-9])0+$/, '$1') + si[i].symbol
    }
  }
  return num.toString()
}

export function toThousandFilter(num) {
  return (+num || 0).toString().replace(/^-?\d+/g, m => m.replace(/(?=(?!\b)(\d{3})+$)/g, ','))
}
export function formatStatus(tsatus) {
  switch (tsatus) {
    case 'Active':
    case 'Normal':
      return '正常'
    case 'Abnormal' :
      return '服务启动中'
    case 'Waiting' :
      return '服务等待中'
    case 'Paused' :
      return '更新暂停中'
    case 'Updating' :
      return '服务更新中'
    case 'RollingBack' :
      return '服务回滚中'
    case 'Terminating':
      return '删除中'
    default :
      return '未知状态'
  }
}
export function formatImages(images) {
  return images.replace('ccr.ccs.tencentyun.com/qa-base/', '')
}

export function filterTag(image) {
  const arr = image.split(':')
  return (arr && arr[1]) || ''
}
