import request from '@/utils/requestPipeline'

export function getApplications(data) {
  return request({
    url: '/manage/application/find',
    method: 'post',
    data
  })
}

export function saveApplication(data) {
  return request({
    url: '/manage/application',
    method: 'post',
    data
  })
}

export function updateApplication(data) {
  return request({
    url: '/manage/application',
    method: 'put',
    data
  })
}

export function getRepos() {
  return request({
    url: '/manage/git/find/repo/all',
    method: 'get'
  })
}

export function getRefs(ref) {
  return request({
    url: `/manage/git/find/repo/${ref}/ref`,
    method: 'get'
  })
}

export function deleteApplication(params) {
  return request({
    url: `/manage/application/${params}`,
    method: 'delete'
  })
}

export function getQuali(data) {
  return request({
    url: '/manage/quali/find',
    method: 'post',
    data
  })
}

export function getFlow() {
  return request({
    url: `/manage/pipeline/list/flow`,
    method: 'get'
  })
}
export function saveAdapter(data) {
  return request({
    url: '/manage/adapter',
    method: 'post',
    data
  })
}
export function getAdapter(id) {
  return request({
    url: `/manage/adapter/list/${id}`,
    method: 'get'
  })
}
export function deleteAdapter(id) {
  return request({
    url: `/manage/adapter/${id}`,
    method: 'delete'
  })
}
export function getAdapters() {
  return request({
    url: '/manage/adapter/list',
    method: 'get'
  })
}
export function getPipelines() {
  return request({
    url: '/manage/pipeline/list/flow',
    method: 'get'
  })
}
export function fetchPipelineEntitys(page, count, data) {
  return request({
    url: `/manage/pipeline/entity/list/${page}/${count}`,
    method: 'post',
    data
  })
}
export function findHook(params) {
  return request({
    url: `/manage/pipeline//hook/find/${params}`,
    method: 'get'
  })
}
export function getPipelineEntity(id) {
  return request({
    url: `/manage/pipeline/entity/${id}`,
    method: 'get'
  })
}
export function getPipelineEntityTaskResult(pipelineEntityid, stageIndex, taskIndex) {
  return request({
    url: `/manage/pipeline/task/detail/${pipelineEntityid}/${stageIndex}/${taskIndex}`,
    method: 'get'
  })
}
export function getLogs(id, start, end) {
  return request({
    url: `/task/exec/log/${id}/${start}/${end}`,
    method: 'get'
  })
}
export function getQualiSonar(data) {
  return request({
    url: `/manage/quali/detail`,
    method: 'post',
    data
  })
}
export function find(pipeline_id) {
  return request({
    url: `/manage/pipeline/find/${pipeline_id}`,
    method: 'get'
  })
}
export function createStage(pipeline_id, data) {
  return request({
    url: `/manage/pipeline/${pipeline_id}/stage/create`,
    method: 'post',
    data
  })
}
export function updateStage(pipeline_id, data) {
  return request({
    url: `/manage/pipeline/${pipeline_id} /stage/update`,
    method: 'put',
    data
  })
}
export function deleteStage(pipeline_id, stage_id) {
  return request({
    url: `/manage/pipeline/${pipeline_id}//stage/delete/${stage_id}`,
    method: 'delete'
  })
}
export function createTask(pipeline_id, stage_id, data) {
  return request({
    url: `/manage/pipeline/${pipeline_id}/${stage_id}/task/create`,
    method: 'post',
    data
  })
}
export function updateTask(pipeline_id, stage_index, data) {
  return request({
    url: `/manage/pipeline/${pipeline_id}/${stage_index}/task/update`,
    method: 'put',
    data
  })
}
export function deleteTask(pipeline_id, stage_index, task_id) {
  return request({
    url: `/manage/pipeline/${pipeline_id}/${stage_index}/task/delete/${task_id}`,
    method: 'delete'
  })
}
export function savePipeline(data) {
  return request({
    url: '/manage/pipeline/create',
    method: 'post',
    data
  })
}
export function updatePipeline(data) {
  return request({
    url: '/manage/pipeline/update',
    method: 'put',
    data
  })
}
export function deletePipeline(pipeline_id) {
  return request({
    url: `/manage/pipeline/delete/${pipeline_id}`,
    method: 'delete'
  })
}
