package cn.qg.qaplatform.controller.yxm;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.entity.kdsp.TSkuInfo;
import cn.qg.qaplatform.process.Purchase;
import cn.qg.qaplatform.service.kdsp.TSkuInfoService;
import cn.qg.qaplatform.utils.Result;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 羊小咩相关接口
 */
@CrossOrigin
@RestController
@RequestMapping("/yxm")
public class YxmController {

    @Autowired
    TSkuInfoService tSkuInfoService;

    /**
     * 获取sku列表
     * @param namespace
     * @param skuSource
     * @param skuNo
     * @param skuName
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/sku/list")
    public Result getSkuList(String namespace,
                             Integer skuSource,
                             String skuNo,
                             String skuName,
                             @RequestParam(defaultValue = "1") Integer pageNum,
                             @RequestParam(defaultValue = "10") Integer pageSize) {
        SwitchDataSource.dataSourceSwitch(namespace, "kdsp");
        QueryWrapper<TSkuInfo> queryWrapper = new QueryWrapper<>();
        if (skuSource != null) {
            queryWrapper.eq("sku_source", skuSource);
        }
        if (!StringUtils.isEmpty(skuNo)) {
            queryWrapper.eq("sku_no", skuNo);
        }
        if (!StringUtils.isEmpty(skuName)) {
            queryWrapper.eq("sku_name", skuName);
        }
        IPage<TSkuInfo> iPage = new Page<>(pageNum, pageSize);
        IPage<TSkuInfo> tSkuInfoIPage = tSkuInfoService.page(iPage, queryWrapper);
        Map<String, Object> map = new HashMap<>();
        map.put("total", tSkuInfoIPage.getTotal());
        map.put("list", tSkuInfoIPage.getRecords());
        return Result.buildSuccessResult(map);
    }

    @PostMapping("/shopping")
    public Result yxmShopping(String namespace, String version, String phoneNo, String skuNo) {
        try {
            String token = Purchase.loginApp(namespace, version,phoneNo);
            Integer addressId = Purchase.getAddressList(namespace, token);
            Map<String, Object> submitParams = Purchase.confirmOrder(namespace, token, skuNo, addressId);
            String orderNo = Purchase.submitOrder(namespace, version, token, submitParams);
            String payStatus = Purchase.queryPayStatus(namespace, version, token, orderNo);
            Purchase.openCheckout(namespace, version, token, orderNo);
            Purchase.payReissueContract(namespace, version, token);
            String flowOrderNo = Purchase.checkoutPrePay(namespace, version, token, orderNo);
            String payPwdSalt = Purchase.vccAccountSalt(namespace, version, token);
            Integer creditPayStatus = Purchase.checkoutPay(namespace, version, token, orderNo, flowOrderNo, payPwdSalt);
        } catch (Exception e) {
            e.printStackTrace();
            return Result.buildErrorStateResult("购物失败！", false);
        }
        return null;
    }
}
