package cn.qg.qaplatform.entity.businessflow;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 申请单表
 */
@Data
@TableName(value = "apply_list")
public class ApplyList {
    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 渠道组编号
     */
    private String channelGroupNo;

    /**
     * 渠道号
     */
    private String channelId;

    /**
     * 产品类型(0-一单一审现金贷/白名单,2-循环额度,4-消费分期-小牛,6-极速版信用钱包,9-资金输出模式)
     */
    private Integer productType;

    /**
     * 用户uuid
     */
    private String uuid;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 申请单状态(1-填写中，2-已填写未授信，3-授信审核中，4-资产分发中（授信审核完成），5-资方分发完成)
     */
    private Integer applyStatus;

    /**
     * 审核状态(0.不通过，1.通过)
     */
    private Integer auditResult;

    /**
     * 审核有效截止时间
     */
    private Date auditValidTime;

    /**
     * 资产分发结果（0失败，1成功）
     */
    private Integer assetsResult;

    /**
     * 资产分发完成时间
     */
    private Date assetsFinishTime;

    /**
     * 申请单提交时间
     */
    private Date applySubmitTime;

    /**
     * 是否可用(0-不可用 1-可用)
     */
    private Integer enable;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 更新时间
     */
    private Date updatedAt;

    /**
     * 审核结束时间
     */
    private Date auditResultTime;
}
