package cn.qg.qaplatform.controller.k8s;

import cn.qg.qaplatform.utils.K8sService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/k8s")
public class K8sController {

    @Autowired
    K8sService k8sService;

    /**
     * 获取k8s环境变量
     * @param namespace 环境
     * @return
     */
    @GetMapping("/listEnvVars")
    public Map getListEnvVars(@RequestParam String namespace) {
        Map<String, Object> detailMap = k8sService.getListEnvVars(namespace);
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("details", detailMap);
        resultMap.put("success", true);
        return resultMap;
    }
}
