package cn.qg.qaplatform.entity.msg;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 消息模板实体类
 */
@Data
@TableName(value = "msg_template")
public class MsgTemplate {

    /**
     * 主键
     */
    @TableId
    private Integer id;

    private Integer type;

    /**
     * 消息标题
     */
    private String title;

    /**
     * 文案内容
     */
    private String content;

    /**
     * 文案参数个数
     */
    private Integer argumentsNumber;

    /**
     * 文案描述
     */
    private String remark;

    /**
     * 落地页连接
     */
    private String navUrl;

    private Long navUrlExpireTime;

    /**
     * 图片连接
     */
    private String picUrl;

    /**
     * 用户群体
     */
    private Integer userSource;

    /**
     * 文本验证码
     */
    private Boolean isTxtV;

    /**
     * 文本短信
     */
    private Boolean isTxtMsg;

    /**
     * 语音验证码
     */
    private Boolean isVoiceV;

    /**
     * 语音短信
     */
    private Boolean isVoiceMsg;

    /**
     * APP推送消息
     */
    private Boolean isPushMsg;

    /**
     * 是否透传条数
     */
    private Boolean isPassThrough;

    /**
     * 存入数据库
     */
    private Boolean isSaveApp;

    /**
     * 营销短信
     */
    private Boolean isSmsMarket;

    /**
     * 轻度催收短信
     */
    private Boolean isSmsCollection;

    private Boolean isVariable;

    /**
     * 逻辑删除
     */
    private Boolean deleted;

    /**
     * 操作人
     */
    private String operator;

    /**
     * 操作人姓名
     */
    private String operatorName;

    private Date createdAt;

    private Date updatedAt;

    /**
     *  微信推送
     */
    private Boolean isWechat;

    /**
     * 文案内容替换
     */
    private String contentReplace;

    /**
     * 渠道类型
     */
    private Integer channelType;

    /**
     * 模板类型
     */
    private Integer templateType;

    /**
     * 消息平台/通道，多个之间英文,分隔，SmsPlatformType - 行业短信；SmsMarketPlatformType - 营销短信，其他类型暂不区分通道
     */
    private String platform;
}
