
package cn.qg.qaplatform.controller.yxm;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.entity.xyqbuser.User;
import cn.qg.qaplatform.service.xyqbUser.UserService;
import cn.qg.qaplatform.utils.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

@Slf4j
@CrossOrigin
@RestController
public class ClearDataController {

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    UserService userService;

    /**
     * 清除用户数据
     * @param namespace 环境
     * @param phoneNo 手机号
     * @return
     */
    @GetMapping("/cleardata")
    public Result clearData(String namespace, String phoneNo) {
        User user = userService.getUserInfoByPhoneNo(namespace, phoneNo);
        if (user == null) {
            return Result.buildErrorStateResult(String.format("%s环境，用户%s不存在，无需清除！", namespace, phoneNo), false);
        }
        String userId = String.valueOf(user.getId());
        String uuid = user.getUuid();

        log.info("开始删除{}环境{}用户kdsp中的数据！", namespace, phoneNo);
        SwitchDataSource.dataSourceSwitch(namespace, "kdsp");
        List<Map<String, Object>> orderList = jdbcTemplate.queryForList("SELECT * FROM `t_order_info` WHERE user_id = " + userId);
        if (orderList.size() > 0) {
            for (Map<String, Object> map: orderList) {
                String orderNo = map.get("order_no").toString();
                jdbcTemplate.execute(String.format("DELETE FROM `t_order_sku` WHERE order_no = '%s'", orderNo));
                jdbcTemplate.execute(String.format("DELETE FROM `t_order_coupon` WHERE order_no = '%s'", orderNo));
                jdbcTemplate.execute(String.format("DELETE FROM `t_order_refund_apply` WHERE order_no = '%s'", orderNo));
                jdbcTemplate.execute(String.format("DELETE FROM `t_order_refund_proof` WHERE order_no = '%s'", orderNo));
            }
        }
        jdbcTemplate.execute("DELETE FROM `t_user_shop_cart` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_user_receiver_addr` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_user_points_detail` WHERE `user_id` = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_user_points` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_order_info` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_order_sku_coupon` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_order_sku_activity` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_ka_process_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_coupon_user` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_comment_info` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_after_service_apply` WHERE user_id = " + userId);

        log.info("开始删除{}环境{}用户vcc_talos中的数据！", namespace, phoneNo);
        SwitchDataSource.dataSourceSwitch(namespace, "vcc_talos");
        jdbcTemplate.execute("DELETE FROM `account` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `account` WHERE phone_no = " + phoneNo);
        jdbcTemplate.execute("DELETE FROM `risk_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `auth_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `contract_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `credit_trade_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `debit_account` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `debit_record` WHERE user_id = " + userId);
        jdbcTemplate.execute(String.format("DELETE FROM `msg_record` WHERE phone_no = '%s'", phoneNo));
        jdbcTemplate.execute("DELETE FROM `order_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `trade_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `shandong_summary` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `trade_contract_record` WHERE user_id = " + userId);


        log.info("开始删除{}环境{}用户acsdb中的数据！", namespace, phoneNo);
        SwitchDataSource.dataSourceSwitch(namespace, "acsdb");
        jdbcTemplate.execute("DELETE FROM `acs_account` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_account` WHERE mobile_no = " + phoneNo);
        jdbcTemplate.execute("DELETE FROM `acs_bill` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_cash_account` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_cash_account_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_cash_back_task` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_commodity` WHERE user_id = " + userId);
        jdbcTemplate.execute(String.format("DELETE FROM `acs_customer` WHERE uuid = '%s'", uuid));
        jdbcTemplate.execute("DELETE FROM `acs_pay_order` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_payment_order` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_plan` WHERE user_id = " + userId);
        jdbcTemplate.execute(String.format("DELETE FROM `acs_sms` WHERE mobile_no = ''", phoneNo));
        jdbcTemplate.execute("DELETE FROM `acs_trans` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_capital_loan_bill` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_capital_loan_bill_flow` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_capital_loan_bill_flow` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_capital_plan` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_compensatory_plan` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_coupon` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_limit` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_limit_package` WHERE user_id = " + userId);


        log.info("开始删除{}环境{}用户vcc_quota中的数据！", namespace, phoneNo);
        SwitchDataSource.dataSourceSwitch(namespace, "vcc_quota");
        jdbcTemplate.execute("DELETE FROM `user_quota_locker` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `user_quota_log` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `user_quota_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `user_quota_package` WHERE user_id = " + userId);

        log.info("开始删除{}环境中的用户{}finance_gateway中的数据！", namespace, phoneNo);
        SwitchDataSource.dataSourceSwitch(namespace, "finance_gateway");
        jdbcTemplate.execute("DELETE FROM `t_finance_user_ref` WHERE `phone_no` = " + phoneNo);

        log.info("开始删除{}环境{}用户xyqb_user中的数据！", namespace, phoneNo);
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb_user");
        List<Map<String, Object>> productLoginList = jdbcTemplate.queryForList("SELECT * FROM `product_login` WHERE EXTENSION_ACCOUNT_ID = " + userId);
        if (productLoginList.size() > 0) {
            for (Map<String, Object> productLogin: productLoginList) {
                String customerId = productLogin.get("CUSTOMER_ID").toString();
                jdbcTemplate.execute(String.format("DELETE FROM `product_login` WHERE CUSTOMER_ID = '%s'", customerId));
                jdbcTemplate.execute(String.format("DELETE FROM `customer_login` WHERE CUSTOMER_ID = '%s'", customerId));
                jdbcTemplate.execute(String.format("DELETE FROM `customer_info` WHERE CUSTOMER_ID = '%s'", customerId));
            }
        }
        jdbcTemplate.execute("DELETE FROM `user` WHERE id = " + userId);
        jdbcTemplate.execute("DELETE FROM `user` WHERE phone_no = " + phoneNo);
        jdbcTemplate.execute("DELETE FROM `user_detail` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `user_detail` WHERE phone_no = " + phoneNo);
        jdbcTemplate.execute("DELETE FROM `wechat_userinfo` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `address` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `user_attached` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `contact` WHERE user_id = " + userId);
        return Result.buildSuccessResult(String.format("%s环境，用户%s数据清除成功", namespace, phoneNo), true);
    }
}
