package cn.qg.qaplatform.automation.service.impl;

import cn.qg.qaplatform.automation.domain.Interface;
import cn.qg.qaplatform.automation.domain.Project;
import cn.qg.qaplatform.automation.domain.Testcase;
import cn.qg.qaplatform.automation.mapper.*;
import cn.qg.qaplatform.automation.service.TestcaseService;
import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.utils.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class TestcaseServiceImpl extends ServiceImpl<TestcaseMapper, Testcase> implements TestcaseService {
    @Autowired
    TestcaseMapper testcaseMapper;

    @Autowired
    InterfaceMapper interfaceMapper;

    @Autowired
    ProjectMapper projectMapper;

    @Override
    public IPage<Testcase> getTestcaseList(Integer projectId, Integer moduleId, Integer pageNum, Integer pageSize) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        IPage<Testcase> page = new Page<>(pageNum, pageSize);
        return testcaseMapper.getTestcaseList(page, projectId, moduleId);
    }

    /**
     * 执行测试用例的方法
     * @param testcaseId 测试用例id
     * @return
     */
    @Override
    public JSONObject exexuteTestcase(Integer testcaseId) throws Exception {
        Testcase testcase = testcaseMapper.selectById(testcaseId);
        Interface interfaceEntity = interfaceMapper.selectById(testcase.getInterfaceId());
        Project project = projectMapper.selectById(interfaceEntity.getProjectId());
        String url = project.getHost().concat(interfaceEntity.getUrl());
        JSONObject response = new JSONObject();
        log.info("本次执行用例名为" + testcase.getName() + ", url为：" + url);
        if (interfaceEntity.getMethod().equals("GET")) {
            Map<String, Object> headers = JSON.parseObject(testcase.getHeaders(), HashMap.class);
            Map<String, Object> params = JSON.parseObject(testcase.getParams(), HashMap.class);
            response = HttpClientUtils.doGetReturnJson(url, params, headers);
            return response;
        } else if (interfaceEntity.getMethod().equals("POST")) {
            Map<String, Object> headers = JSON.parseObject(testcase.getHeaders(), HashMap.class);
            if (interfaceEntity.getParamsType().equals("form")) {
                Map<String, Object> formData = JSON.parseObject(testcase.getParams(), HashMap.class);
                response = HttpClientUtils.doPost(url, formData, headers);
                return response;
            } else if (interfaceEntity.getParamsType().equals("json")) {
                JSONObject resposne = HttpClientUtils.doPostJson(url, testcase.getParams(), headers);
                return resposne;
            }
        } else {
            throw new Exception("请求方式不支持，当前只支持GET、POST请求！");
        }
        return null;
    }
}
