package cn.qg.qaplatform.zdata.controller.xyqb;

import cn.qg.qaplatform.utils.JsonResult;
import cn.qg.qaplatform.zdata.service.xyqb.ClearDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
public class ClearDataController {

    @Autowired
    ClearDataService clearDataService;

    /**
     * 清除用户数据
     * @param namespace 环境
     * @param phoneNo 手机号
     * @return
     */
    @GetMapping("/cleardata")
    public JsonResult clearData(String namespace, String phoneNo) {
        return JsonResult.success(clearDataService.clearData(namespace, phoneNo));
    }
}
