package cn.quantgroup.qaplatform.service.impl;

import cn.quantgroup.qaplatform.config.DynamicDataSource;
import cn.quantgroup.qaplatform.domain.LoanUser;
import cn.quantgroup.qaplatform.service.BasicLoanStatusDataService;
import cn.quantgroup.qaplatform.service.LoanUserDataService;
import cn.quantgroup.qaplatform.utils.RandomDataUtil;
import cn.quantgroup.qaplatform.utils.page.PageResult;
import cn.quantgroup.qaplatform.utils.page.PageUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 查询旧有数据
 */
@Service
public class LoadUserDataServiceImpl implements LoanUserDataService {

    @Autowired
    private BasicLoanStatusDataService basicLoanStatusDataService;

    /**
     * 筛选某个状态的用户（0-未登录，1-未申请，2-审核中，3-审核通过待提现，4-放款中，5-放款失败，6-还款中，7-审核拒绝）
     * @param namespace 环境
     * @param status 用户状态
     * @return
     */
    @Override
    public PageResult getLoanUserData(String namespace, Integer status, Integer pageNum, Integer pageSize) {

        List<LoanUser> result = new ArrayList<>();

        /**
         * 0-未登录
         */
        if (status == 0) {
            int count = 0;
            do {
                String phone = RandomDataUtil.createMobile();
                LoanUser loanUser = new LoanUser();
                if (!basicLoanStatusDataService.queryIfPhoneExist(namespace, phone)) {
                    loanUser.setPhoneNo(phone);
                    result.add(loanUser);
                    count++;
                }
            } while (count < 10);
            PageInfo<LoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 1-未申请
         */
        if (status == 1) {
            List<String> uuidList = basicLoanStatusDataService.getUnApplyUserUuidList(namespace);
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUuidList(namespace, uuidList);
            PageInfo<LoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }


        /**
         * 3-审核通过
         */
        if (status == 3) {
            List<String> userIdList = basicLoanStatusDataService.getReviewPassedUserIdList(namespace);
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            PageInfo<LoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }
        return null;
    }

    /**
     * 清除数据源并重置为默认数据源
     * @throws Throwable
     */
    protected void finalize() throws Throwable {
        super.finalize();
        DynamicDataSource.clear();
    }
}
