package cn.quantgroup.qaplatform.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.*;

@Slf4j
public class HttpClientUtil {

    private static CloseableHttpClient client = HttpClients.createDefault();

    public static String doGet(String url) {
        HttpGet get = new HttpGet(url);
        String respStr = null;
        Map<String, Object> resultMap = new HashMap<>();
        try {
            CloseableHttpResponse response = client.execute(get);
            HttpEntity httpEntity = response.getEntity();
            respStr = EntityUtils.toString(httpEntity, "utf-8");
//            resultMap =  JsonTransUtil.strToMap(respStr);
        } catch (IOException e) {
            e.printStackTrace();
        }
//        return resultMap;
        return respStr;
    }

    public static String doGet(String url, Map<String, Object> params) throws URISyntaxException {
//        HttpGet get = new HttpGet(url);
        URIBuilder uriBuilder = new URIBuilder(url);
        if (params != null && !params.isEmpty()) {
            Set<String> keySet = params.keySet();
            for(String key: keySet) {
                uriBuilder.setParameter(key, params.get(key).toString());
            }
        }
        HttpGet get = new HttpGet(uriBuilder.build());
        String respStr = null;
        try {
            CloseableHttpResponse response = client.execute(get);
            HttpEntity httpEntity = response.getEntity();
            respStr = EntityUtils.toString(httpEntity, "utf-8");
            System.out.println(respStr);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return respStr;
    }


    public static void doPost(String url, String params) {
        try {
            HttpPost post = new HttpPost(url);
            List<NameValuePair> list = new ArrayList<>();
            if (StringUtils.isNotEmpty(params)) {
                String[] splitStrings = params.split("&");
                for (String splitString : splitStrings) {
                    String[] split = splitString.split("=");
                    list.add(new BasicNameValuePair(split[0], split[1]));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(list, "utf-8");
                post.setEntity(urlEncodedFormEntity);
            }
            CloseableHttpResponse response = client.execute(post);
            HttpEntity responseEntity = response.getEntity();
            String responseString = EntityUtils.toString(responseEntity, "utf-8");
            System.out.println(responseString);

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void doPost(String url, Map<String, Object> params) {
        try {
            HttpPost post = new HttpPost(url);
            List list = new ArrayList();
            if (params != null && !params.isEmpty()) {
                Set<String> keySet = params.keySet();
                for (String key : keySet) {
                    list.add(new BasicNameValuePair(key, params.get(key).toString()));
                }
                UrlEncodedFormEntity urlEncodedFormEntity =
                        new UrlEncodedFormEntity(list, "utf-8");
                post.setEntity(urlEncodedFormEntity);
            }
            CloseableHttpResponse response = client.execute(post);
            HttpEntity responseEntity = response.getEntity();
            String responseString = EntityUtils.toString(responseEntity, "utf-8");
            System.out.println(responseString);

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Object> doPost(String url, Map<String, Object> params, Map<String, Object> headers) {
        Map<String, Object> resultMap = new HashMap<>();
        try {
            HttpPost post = new HttpPost(url);
            List list = new ArrayList();
            if (params != null && !params.isEmpty()) {
                Set<String> keySet = params.keySet();
                for (String key : keySet) {
                    list.add(new BasicNameValuePair(key, params.get(key).toString()));
                }
                UrlEncodedFormEntity urlEncodedFormEntity =
                        new UrlEncodedFormEntity(list, "utf-8");
                post.setEntity(urlEncodedFormEntity);
            }
            if (headers != null && !headers.isEmpty()) {
                Set<String> keySet = headers.keySet();
                for (String s : keySet) {
                    post.addHeader(s, headers.get(s).toString());
                }
            }
            CloseableHttpResponse response = client.execute(post);
            HttpEntity responseEntity = response.getEntity();
            String responseString = EntityUtils.toString(responseEntity, "utf-8");
            resultMap = JsonTransUtil.strToMap(responseString);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public static void doPostJson(String url, String params, String headers) {
        HttpPost httpPost = new HttpPost(url);
        if (StringUtils.isNotEmpty(params)) {
            StringEntity stringEntity = new StringEntity(params, "utf-8");
            httpPost.setEntity(stringEntity);
        }
        if (StringUtils.isNotEmpty(headers)) {
            httpPost.setHeader("Content-Type", "application/json");
        }
        try {
            CloseableHttpResponse response = client.execute(httpPost);
            HttpEntity responseEntity = response.getEntity();
            String toString = EntityUtils.toString(responseEntity, "utf-8");
            System.out.println(toString);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Object> doPostJson(String url, String params, Map<String, Object> headers) {
        HttpPost httpPost = new HttpPost(url);
        Map<String, Object> resultMap = new HashMap<>();
        if (StringUtils.isNotEmpty(params)) {
            StringEntity stringEntity = new StringEntity(params, "utf-8");
            httpPost.setEntity(stringEntity);
        }
        if (headers != null && !headers.isEmpty()) {
            Set<String> keySet = headers.keySet();
            for (String s : keySet) {
                httpPost.addHeader(s, headers.get(s).toString());
            }
        }
        try {
            CloseableHttpResponse response = client.execute(httpPost);
            HttpEntity responseEntity = response.getEntity();
            String responseStr = EntityUtils.toString(responseEntity, "utf-8");
            resultMap = JsonTransUtil.strToMap(responseStr);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String url = "http://passportapi-qa.liangkebang.net/user/login/fastV1";
        String phoneNo = "13712345678:0000";
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] textByte = phoneNo.getBytes("UTF-8");
        String phoneNoBase64 = encoder.encodeToString(textByte);
        Map<String, Object> headers = new HashMap<>();
        Map<String, Object> formData = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Authorization", "Verification " + phoneNoBase64);
        formData.put("channelId", 1);
        formData.put("createdFrom", 1);
        formData.put("key", "xyqb");
        formData.put("btRegisterChannelId", "");
        formData.put("dimension", "");
        formData.put("click_id", "");
        Map<String,Object> resMap =  doPost(url, formData, headers);
        System.out.println(resMap.keySet());
    }

}
