package cn.quantgroup.qaplatform.dao;


import cn.quantgroup.qaplatform.domain.LoanUser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.util.List;

public interface BasicLoanStatusDataMapper {

    /**
     * 根据uuidList获取用户数据信息
     * @param uuidList
     * @return
     */
    List<LoanUser> getUserDataListByUuidList(List<String> uuidList);

    /**
     * 获取未申请用户数据uuidList
     */
    List<String> getUnApplyLoanUserUuidList();

    /**
     * 判断手机号是否存在库里
     */
    Object queryIfPhoneExist(String phone);

    /**
     * 查询审核中的user_id
     */
    List<String> getReviewPassedUserIdList();

    /**
     * 根据userIdList获取用户信息列表
     * @param userIdList
     * @return
     */
    List<LoanUser> getUserDataListByUserIdList(List<String> userIdList);
    
}
