package cn.quantgroup.qaplatform.common.enums;

/**
 * 借款状态枚举
 */
public enum LoanStatus {

    UNLOGIN(0, "未登录"),
    UNAPPLY(1, "未申请"),
    UNDER_REVIEW(2, "审核中"),
    REVIEW_PASS(3, "审核通过"),
    REVIEW_REFUSE(4, "审核拒绝"),
    LOAN_ING(5, "放款中"),
    LOAN_SUCESS(6, "放款成功"),
    LOAN_FAIL(7, "放款失败"),
    MULTI_ORDER(8, "多订单未申请");

    private Integer status;
    private String desc;

    LoanStatus(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }
}
