package cn.qg.qaplatform.service.impl;

import cn.qg.qaplatform.config.WebSocketServer;
import cn.qg.qaplatform.service.QueryBasicLoanStatusDataService;
import cn.qg.qaplatform.service.QueryInProcessStatusService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class QueryInProcessStatusServiceImpl implements QueryInProcessStatusService {

    @Autowired
    QueryBasicLoanStatusDataService queryBasicLoanStatusDataService;

    @Override
    public void queryFundingAssignProgress(String namespace, String phoneNo, Integer fundId, String symbol) throws InterruptedException {
        String userId = queryBasicLoanStatusDataService.getUserInfoByPhoneNo(namespace, phoneNo).getUserId();
        while (true) {
            Integer searchResult = queryBasicLoanStatusDataService.getAssignFundIdByUserId(namespace, userId);
            log.info(searchResult.toString());
            if (fundId.equals(searchResult)) {
                log.info("用户：" + userId + "资方分配成功!");
                if (!StringUtils.isEmpty(symbol)) {
                    WebSocketServer.sendInfo("查询到的资方为：" + searchResult +",资方分配成功.", symbol);
                }
                break;
            } else {
                if (!StringUtils.isEmpty(symbol)) {
                    WebSocketServer.sendInfo("查询到的资方为：" + searchResult +",资方还未分配成功，10秒后重试", symbol);
                }
                Thread.sleep(10000);
            }
        }
    }

    @Override
    public void queryLoanProgress(String namespace, String phoneNo, String symbol) throws InterruptedException {
        String userId = queryBasicLoanStatusDataService.getUserInfoByPhoneNo(namespace, phoneNo).getUserId();
        while (true) {
            Integer progress = queryBasicLoanStatusDataService.getLoanProgressByUserId(namespace, userId);
            if (progress == 15) {
                log.info("用户：" + userId + "放款成功！");
                if (!StringUtils.isEmpty(symbol)) {
                    WebSocketServer.sendInfo("放款成功.", symbol);
                }
                break;
            } else {
                if (!StringUtils.isEmpty(symbol)) {
                    WebSocketServer.sendInfo("查询到的状态为：" + progress + "，资方放款中，30秒后重新查询状态！", symbol);
                }
                Thread.sleep(30000);
            }
        }
    }
}
