package cn.qg.qaplatform.controller.common;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.entity.vo.BindCardVo;
import cn.qg.qaplatform.entity.xyqbuser.User;
import cn.qg.qaplatform.service.xyqbUser.UserService;
import cn.qg.qaplatform.utils.HttpClientUtils;
import cn.qg.qaplatform.utils.Result;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@CrossOrigin
@RestController
public class BindCardController {

    @Autowired
    UserService userService;

    @PostMapping("/bind/card")
    public Result bindBankCard(@RequestBody BindCardVo bindCardVo) {
        try {
            String namespace = bindCardVo.getNamespace();
            String phoneNo = bindCardVo.getPhoneNo();
            String bankCode = bindCardVo.getBankCode();
            String cardNo = bindCardVo.getCardNo();
            SwitchDataSource.dataSourceSwitch(namespace, "xyqb_user");
            QueryWrapper<User> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("phone_no",  phoneNo);
            User user = userService.getOne(queryWrapper);
            if (user == null) {
                return Result.buildErrorStateResult("用户不存在!", false);
            }
            String bindCardRequestUrl = "https://payapi-" + namespace + ".liangkebang.net/ex/common/card/bind_card/request";
            String bindCardConfirmUrl = "https://payapi-" + namespace + ".liangkebang.net/ex/common/card/sms_confirm";
            Map<String, String> bindCardRequestParam = new HashMap<>();
            Map<String, String> bindCardConfirmParam = new HashMap<>();
            String requestId = RandomStringUtils.random(10, "0123456789");
            // 绑卡请求
            bindCardRequestParam.put("requestId", requestId);
            bindCardRequestParam.put("bankCode", bankCode);
            bindCardRequestParam.put("cardNo", cardNo);
            bindCardRequestParam.put("preservePhoneNo", phoneNo);
            bindCardRequestParam.put("channel", "21");
            bindCardRequestParam.put("userId", String.valueOf(user.getId()));
            bindCardRequestParam.put("uuid", user.getUuid());
            bindCardRequestParam.put("orderNo", RandomStringUtils.random(15));
            // 绑卡确认
            bindCardConfirmParam.put("cardNo", cardNo);
            bindCardConfirmParam.put("requestId", requestId);
            bindCardConfirmParam.put("validateCode", "000000");
            HttpClientUtils.doPostJson(bindCardRequestUrl, JSON.toJSONString(bindCardRequestParam));
            HttpClientUtils.doPostJson(bindCardConfirmUrl, JSON.toJSONString(bindCardConfirmParam));
        } catch (Exception e) {
            e.printStackTrace();
            return Result.buildErrorStateResult("绑卡失败，请检查支付中心是否正常！", false);
        }
        return Result.buildSuccessResult("绑卡成功！");
    }
}
