package cn.qg.qaplatform.enums;


/**
 * 享花卡状态枚举
 */
public enum VccStatusEnum {
    CREATED("初始状态", 0),
    ACTIVATE_SUCC("授信成功", 1),
    ACTIVATE_FAILED("授信失败", 2),
    DISABLE("禁用",3),
    AUTHING("审核中",4),
    FREZE("冻结",5),
    XYQB_OPEN_SUCC("开户成功", 6),
    XYQB_OPEN_FAILED("开户失败",7);

    private String desc;
    private Integer code;

    VccStatusEnum(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getCode() {
        return this.code;
    }

    /**
     * 根据code码获取描述
     * @param code code
     * @return desc
     */
    public static String getDescByCode(Integer code) {
        VccStatusEnum[] vccStatusEnums = values();
        for (VccStatusEnum vccStatusEnum: vccStatusEnums) {
            if (vccStatusEnum.getCode().equals(code)) {
                return vccStatusEnum.getDesc();
            }
        }
        return null;
    }
}
