package cn.qg.qaplatform.process;

import cn.qg.qaplatform.utils.HttpClientUtils;
import cn.qg.qaplatform.utils.JsonResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.JsonPath;

import java.net.URISyntaxException;
import java.util.*;

/**
 * 电商购买相关方法
 * @author libo
 */
public class Purchase {

    public static String loginApp(String namespace, String phoneNo) {
        String url = "http://sappbackend-" + namespace + ".liangkebang.net/auth/fast-login";
        Map<String, Object> headers = new HashMap<>();
        Map<String, Object> params = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("version", "7.9.00");
        headers.put("channel", 214);
        headers.put("appName", "xinyongqianbao");
        headers.put("idfa", "D69C97EC-AC7F-4C5D-AC14-50933E990795");
        headers.put("device_id", "D69C97EC-AC7F-4C5D-AC14-50933E990795");
        params.put("createdFrom", 214);
        params.put("username", phoneNo);
        params.put("vcode", "000000");
        JSONObject response = HttpClientUtils.doPost(url, params, headers);
        System.out.println(response);
        return JsonPath.read(response, "$.token");
    }

    public static List<Integer> getAddressList(String namespace, String token) throws URISyntaxException {
        String url = "http://talos-" + namespace + ".liangkebang.net/api/kdsp/addr/receiver/list";
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", token);
        JSONObject response = HttpClientUtils.doGetReturnJson(url, null, headers);
        System.out.println(response);
//        if (JsonPath.read(response, "$.data"))
        List<Integer> addressIdList = JsonPath.read(response, "$.data.addrReceiverList[*].addrReceiverId");
        System.out.println(addressIdList);
        return addressIdList;
    }

    public static boolean confirmOrder(String namespace, String token, String skuNo, Integer addrReceiverId) {
        String url = "http://talos-" + namespace + ".liangkebang.net/api/kdsp/shop-cart/order-confirm/page/v2";
        Map<String, Object> headers = new HashMap<>();
        Map<String, Object> params = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("x-auth-token", token);
        List<Map<String, Object>> skuList = new ArrayList<>();
        List<String> couponActivityUseIdList = new ArrayList<>();
        Map<String, Object> skuMap = new HashMap<>();
        skuMap.put("skuNum", 1);
        skuMap.put("skuSource", 1);
        skuMap.put("skuId", skuNo);
        skuList.add(skuMap);
        params.put("selectedSkuList", skuList);
        params.put("defaultUseCashCoupon", true);
        params.put("defaultUseFreightFeeCoupon", true);
        params.put("couponActivityUseIdList", couponActivityUseIdList);
        params.put("defaultUseActivityCoupon", true);
        params.put("defaultUseCoupon", true);
        params.put("addrReceiverId", addrReceiverId);
        System.out.println("params: " + params);
        JSONObject response = HttpClientUtils.doPostJson(url, JSON.toJSONString(params), headers);
        System.out.println(response);
        return true;
    }

    public static String submitOrder() {
        return null;
    }

    public static void main(String[] args) throws Exception {
        String namespace = "test1";
        String token = loginApp(namespace, "18300002000");
        List<Integer> addressIdList = getAddressList(namespace, token);
        confirmOrder(namespace, token, "3907019609089", addressIdList.get(0));

    }

}
