package cn.qg.qaplatform.controller.yxm;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.entity.kdsp.TSkuInfo;
import cn.qg.qaplatform.entity.vcc.Account;
import cn.qg.qaplatform.entity.xyqbuser.User;
import cn.qg.qaplatform.process.Yxm;
import cn.qg.qaplatform.service.kdsp.TSkuInfoService;
import cn.qg.qaplatform.service.vcc.AccountService;
import cn.qg.qaplatform.utils.Result;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 羊小咩相关接口
 */
@CrossOrigin
@RestController
@RequestMapping("/yxm")
public class YxmController {

    @Autowired
    TSkuInfoService tSkuInfoService;

    @Autowired
    AccountService accountService;

    /**
     * 获取sku列表
     * @param namespace 环境
     * @param skuSource 商品来源 1-自营 2-京东开普勒 3-京东联盟 4-众联 5-企业购 6-企业购直连
     * @param skuNo skuNo
     * @param skuName sku名称
     * @param pageNum 第几页
     * @param pageSize 每页多少个
     * @return
     */
    @GetMapping("/sku/list")
    public Result getSkuList(String namespace,
                             Integer skuSource,
                             String skuNo,
                             String skuName,
                             @RequestParam(defaultValue = "1") Integer pageNum,
                             @RequestParam(defaultValue = "10") Integer pageSize) {
        // namespace不能为空
        if (!StringUtils.isEmpty(namespace)) {
            return Result.buildErrorStateResult("namespace不能为空！", false);
        }
        SwitchDataSource.dataSourceSwitch(namespace, "kdsp");
        QueryWrapper<TSkuInfo> queryWrapper = new QueryWrapper<>();
        if (skuSource != null) {
            queryWrapper.eq("sku_source", skuSource);
        }
        if (!StringUtils.isEmpty(skuNo)) {
            queryWrapper.eq("sku_no", skuNo);
        }
        if (!StringUtils.isEmpty(skuName)) {
            queryWrapper.eq("sku_name", skuName);
        }
        IPage<TSkuInfo> iPage = new Page<>(pageNum, pageSize);
        IPage<TSkuInfo> tSkuInfoIPage = tSkuInfoService.page(iPage, queryWrapper);
        Map<String, Object> map = new HashMap<>();
        map.put("total", tSkuInfoIPage.getTotal());
        map.put("list", tSkuInfoIPage.getRecords());
        return Result.buildSuccessResult("获取sku列表成功.", map);
    }

    /**
     * 羊小咩购物接口
     * @param namespace 环境
     * @param version 羊小咩App版本
     * @param phoneNo 手机号
     * @param skuNo skuNo
     * @return
     */
    @PostMapping("/order")
    public Result yxmShopping(String namespace, String version, String phoneNo, String skuNo) {
        SwitchDataSource.dataSourceSwitch(namespace, "vcc_talos");
        QueryWrapper<Account> accountQueryWrapper = new QueryWrapper<>();
        accountQueryWrapper.eq("phone_no", phoneNo);
        Account account = accountService.getOne(accountQueryWrapper);
        if (account == null) {
            return Result.buildErrorStateResult("用户未开通享花卡，请先开通享花卡！", false);
        }
        if (account.getStatus() != 6) {
            return Result.buildErrorStateResult("用户未开户成功，请先开户成功！", false);
        }
        try {
            String token = Yxm.loginApp(namespace, version,phoneNo);
            Integer addressId = Yxm.getAddressList(namespace, phoneNo, token);
            Map<String, Object> submitParams = Yxm.confirmOrder(namespace, token, skuNo, addressId);
            String orderNo = Yxm.submitOrder(namespace, version, token, submitParams);
            String payStatus = Yxm.queryPayStatus(namespace, version, token, orderNo);
            Yxm.openCheckout(namespace, version, token, orderNo);
            Yxm.payReissueContract(namespace, version, token);
            String flowOrderNo = Yxm.checkoutPrePay(namespace, version, token, orderNo);
            String payPwdSalt = Yxm.vccAccountSalt(namespace, version, token);
            Integer creditPayStatus = Yxm.checkoutPay(namespace, version, token, orderNo, flowOrderNo, payPwdSalt);
        } catch (Exception e) {
            e.printStackTrace();
            return Result.buildErrorStateResult("下单失败！", false);
        }
        return Result.buildSuccessResult("下单成功！", true);
    }

    /**
     * 绑定收货地址
     * @param namespace 环境
     * @param version 羊小咩App版本
     * @param phoneNo 手机号
     * @return
     */
    @PostMapping("/bind/address")
    public Result bindReceiveAddr(String namespace, String version, String phoneNo) {
        try {
            String token = Yxm.loginApp(namespace, version, phoneNo);
            Yxm.addAddress(namespace, phoneNo, token);
        } catch (Exception e) {
            e.printStackTrace();
            return Result.buildErrorStateResult("地址绑定失败！", false);
        }
        return Result.buildSuccessResult("地址绑定成功！", true);
    }
}
