package cn.qg.qaplatform.mock.config;

import cn.qg.qaplatform.mock.interceptor.YeebaoInterceptor;
import cn.qg.qaplatform.mock.interceptor.YeebaoTransferInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;


@Configuration
public class InterceptorConfig implements WebMvcConfigurer {

    @Bean
    public YeebaoInterceptor yeebaoInterceptor() {
        return new YeebaoInterceptor();
    }

    @Bean
    public YeebaoTransferInterceptor yeebaoTransferInterceptor() { return new YeebaoTransferInterceptor(); }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(yeebaoInterceptor()).addPathPatterns("/mock/tzt-api/**");
        registry.addInterceptor(yeebaoTransferInterceptor()).addPathPatterns("/mock/balance-board/**");
    }

}
