package cn.qg.qaplatform.controller.zdata.vcc;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.entity.vcc.Account;
import cn.qg.qaplatform.entity.vcc.AcsPayOrder;
import cn.qg.qaplatform.entity.vcc.RiskRecord;
import cn.qg.qaplatform.entity.vcc.UserQuotaRecord;
import cn.qg.qaplatform.entity.xyqbuser.User;
import cn.qg.qaplatform.entity.zdata.VccOpenResultVo;
import cn.qg.qaplatform.entity.zdata.VccUserEntity;
import cn.qg.qaplatform.process.Vcc;
import cn.qg.qaplatform.service.vcc.AccountService;
import cn.qg.qaplatform.service.vcc.AcsPayOrderService;
import cn.qg.qaplatform.service.vcc.RiskRecordService;
import cn.qg.qaplatform.service.vcc.UserQuotaRecordService;
import cn.qg.qaplatform.service.xyqbUser.UserService;
import cn.qg.qaplatform.service.zdata.vcc.VccDataService;
import cn.qg.qaplatform.utils.HttpClientUtils;
import cn.qg.qaplatform.utils.JsonResult;
import cn.qg.qaplatform.utils.Result;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * vcc 相关接口
 * @author libo
 */
@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/vcc")
public class VccController {

    @Autowired
    UserService userService;

    @Autowired
    AccountService accountService;

    @Autowired
    UserQuotaRecordService userQuotaRecordService;

    @Autowired
    RiskRecordService riskRecordService;

    @Autowired
    AcsPayOrderService acsPayOrderService;

    @Autowired
    VccDataService vccDataService;

    /**
     * vcc造数据
     * @param namespace 环境
     * @param phoneNo 手机号
     * @param channel 渠道号
     * @param status 状态
     * @return
     * @throws Exception
     */
    @PostMapping("/gen")
    public JsonResult genVccUser(@RequestParam(value = "namespace") String namespace,
                                 @RequestParam(value = "phoneNo") String phoneNo,
                                 @RequestParam(value = "channel") String channel,
                                 @RequestParam(value = "status") Integer status) throws Exception {
        if (status !=1 && status !=2 && status !=3 && status !=4) {
            return JsonResult.clientFailed("状态值必须是1、2、3、4中的一个！");
        }
        VccOpenResultVo result = vccDataService.makeVccUser(namespace, phoneNo, channel, status);
        if (result == null) {
            return JsonResult.serverFailed();
        }
        return JsonResult.success(result);
    }

    /**
     * vcc捞数据
     * @param namespace 环境
     * @param status 状态
     * @param pageNum 第几页
     * @param pageSize 每页展示多少个
     * @return
     */
    @GetMapping("/getData")
    public Result getVccData(@RequestParam(value = "namespace") String namespace,
                             @RequestParam(value = "status") Integer status,
                             @RequestParam(defaultValue = "1") Integer pageNum,
                             @RequestParam(defaultValue = "10") Integer pageSize) {
        // 数据源切换到vcc_talos
        SwitchDataSource.dataSourceSwitch(namespace, "vcc_talos");
        IPage<Account> accountIPage = new Page<>(pageNum, pageSize);
        QueryWrapper<Account> accountQueryWrapper = new QueryWrapper<>();
        accountQueryWrapper.eq("status", status);
        IPage<Account> accountIPageResult = accountService.page(accountIPage, accountQueryWrapper);
        List<VccUserEntity> vccUserEntityList = new ArrayList<>();
        QueryWrapper<UserQuotaRecord> userQuotaRecordQueryWrapper = new QueryWrapper<>();
        // 数据源切换到vcc_quota
        SwitchDataSource.dataSourceSwitch(namespace, "vcc_quota");
        for (Account account: accountIPageResult.getRecords()) {
            VccUserEntity vccUserEntity = new VccUserEntity();
            vccUserEntity.setUserId(String.valueOf(account.getUserId()));
            vccUserEntity.setUuid(account.getUuid());
            vccUserEntity.setPhoneNo(account.getPhoneNo());
            vccUserEntity.setRegisteredFrom(account.getRegisteredFrom());
            vccUserEntity.setNextApplyTime(account.getNextApplyTime());
            vccUserEntity.setStatus(account.getStatus());
            vccUserEntity.setType(account.getType());
            vccUserEntity.setCreatedAt(account.getCreatedAt());
            userQuotaRecordQueryWrapper
                    .eq("uuid", account.getUuid())
                    .orderByDesc("id");
            List<UserQuotaRecord> userQuotaRecordList = userQuotaRecordService.list(userQuotaRecordQueryWrapper);
            if (userQuotaRecordList.size() > 0) {
                vccUserEntity.setRiskAmount(userQuotaRecordList.get(0).getRiskAmount());
                vccUserEntity.setEnableAmount(userQuotaRecordList.get(0).getEnableAmount());
            }
            vccUserEntityList.add(vccUserEntity);
            userQuotaRecordQueryWrapper.clear();
        }
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("total", accountIPageResult.getTotal());
        resultMap.put("list", vccUserEntityList);
        return Result.buildSuccessResult(resultMap);
    }

    /**
     * vcc查数据
     * @param namespace 环境
     * @param phoneNo 手机号
     * @return
     */
    @GetMapping("/checkData")
    public Result checkUserData(String namespace, String phoneNo) {
        SwitchDataSource.dataSourceSwitch(namespace, "vcc_talos");
        QueryWrapper<Account> accountQueryWrapper = new QueryWrapper<>();
        accountQueryWrapper.eq("phone_no", phoneNo);
        Account account = accountService.getOne(accountQueryWrapper);
        if (account == null) {
            return Result.buildErrorStateResult("该用户不是VCC用户", false);
        }
        return Result.buildSuccessResult(account);
    }

    /**
     * VCC风控授信回调
     * @param namespace 环境
     * @param phoneNo 手机号
     * @param result 回调结果，true-授信成功，false-授信失败
     * @param amount
     * @return
     */
    @GetMapping("/risk")
    public Result vccRiskControl(String namespace, String phoneNo, Boolean result, Integer amount)  {
        if (amount == null) {
            amount = 10000;
        }
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb_user");
        QueryWrapper<User> userQueryWrapper = new QueryWrapper<>();
        userQueryWrapper.eq("phone_no", phoneNo);
        User user = userService.getOne(userQueryWrapper);
        if (user == null) {
            return Result.buildErrorStateResult("用户不存在", false);
        }
        String uuid = user.getUuid();
        SwitchDataSource.dataSourceSwitch(namespace, "vcc_talos");
        QueryWrapper<RiskRecord> riskRecordQueryWrapper = new QueryWrapper<>();
        riskRecordQueryWrapper.eq("uuid", uuid).orderByDesc("id");
        List<RiskRecord> riskRecordList = riskRecordService.list(riskRecordQueryWrapper);
        if (riskRecordList.size() == 0) {
            return Result.buildErrorStateResult("risk_record未找到授信提交记录", false);
        }
        if (riskRecordList.get(0).getApplyStatus() == 1) {
            return Result.buildErrorStateResult("用户已风控授信拒绝，无法重新授信回调！", false);
        }
        if (riskRecordList.get(0).getApplyStatus() == 2) {
            return Result.buildErrorStateResult("用户已完成授信，无法重新授信回调!", false);
        }
        String riskNo = riskRecordList.get(0).getRiskNo();
        JSONObject creditResult = Vcc.vccWindControlCreditCallback(namespace, uuid, riskNo, result, amount);
        if (creditResult.get("content").toString().equals("success")) {
            return Result.buildSuccessResult("授信回调成功！");
        } else {
            return Result.buildErrorStateResult("授信回调失败，请依次检查vcc_talos、acs_service、vcc_quota是否有报错", false);
        }
    }

    /**
     * vcc还款回调
     * @param namespace 环境
     * @param phoneNo 手机号
     * @param result 回调结果
     * @return
     */
    @GetMapping("/repay/callback")
    public Result vccRepayCallback(String namespace, String phoneNo, Integer result) {
        String url = "https://acs-" + namespace + ".liangkebang.net/ex/paycenter/repay_notify";
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb_user");
        QueryWrapper<User> userQueryWrapper = new QueryWrapper<>();
        userQueryWrapper.eq("phone_no", phoneNo);
        User user = userService.getOne(userQueryWrapper);
        if (user == null)  {
            return Result.buildErrorStateResult("该用户不存在！", false);
        }
        SwitchDataSource.dataSourceSwitch(namespace, "acsdb");
        QueryWrapper<AcsPayOrder> acsPayOrderQueryWrapper = new QueryWrapper<>();
        acsPayOrderQueryWrapper.eq("user_id", user.getId()).orderByDesc("id");
        List<AcsPayOrder> acsPayOrderList = acsPayOrderService.list(acsPayOrderQueryWrapper);
        if (acsPayOrderList.size() == 0) {
            return Result.buildErrorStateResult("acs_pay_order未查到用户有还款记录", false);
        }
        Integer orderNo = acsPayOrderList.get(0).getId();
        Map<String, Object> formData = new HashMap<>();
        formData.put("orderNo", orderNo);
        if (result.equals(1)) {
            formData.put("remark", "还款成功");
        }
        if (result.equals(2)) {
            formData.put("remark", "还款失败");
        }
        formData.put("payStatus", result);
        formData.put("orderData", "{\"payApproachDesc\":\"易宝-广达小贷-VCC专用\",\"orderId\":\"79884519018498\",\"payApproach\":\"65\",\"payApproachName\":\"YEE_PAY_GDXD_VCC\",\"payGateway\":\"0\",\"cardNo\":\"6217000025253636858\",\"payGatewayName\":\"YEE_PAY\"}");
        JSONObject response = HttpClientUtils.doPost(url, formData);
        log.info("{}环境，用户{}，VCC还款回调结果：{}", namespace, phoneNo, response);
        try {
            if (response.get("content").equals("SUCCESS")) {
                return Result.buildSuccessResult("还款回调成功！");
            }
        } catch (Exception e) {
            e.printStackTrace();
            return Result.buildErrorStateResult(JSON.toJSONString(response), false);
        }
        return Result.buildSuccessResult("还款回调成功！");
    }
}
