package cn.qg.qaplatform.service.impl;

import cn.qg.qaplatform.domain.ApplyLoanInfo;
import cn.qg.qaplatform.process.xyqb.MainProcess;
import cn.qg.qaplatform.service.GenUserDataService;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class GenUserDataServiceImpl implements GenUserDataService {

    /**
     * 授信
     * @param applyLoanInfo 造数据的相关信息
     * @return
     * @throws Exception
     */
    @Override
    public boolean quotaAuth(ApplyLoanInfo applyLoanInfo, boolean auditResult) throws Exception {
        String namespace = applyLoanInfo.getNamespace();
        String phoneNo = applyLoanInfo.getPhoneNo();
        Integer channelId = applyLoanInfo.getChannel();
        Integer fundId = applyLoanInfo.getFundId();
        Integer amount = applyLoanInfo.getAmount();
        Integer term = applyLoanInfo.getTerm();

        // 登录
        String token = MainProcess.login(namespace, channelId, phoneNo);
        // 查询用户中心id
        Map map = MainProcess.checkUserId(namespace, phoneNo);
        String uuid = map.get("uuid").toString();
        String userId = map.get("id").toString();
        // 同步session到xyqb
        MainProcess.syncSessionToXyqb(namespace, token);
        // 授信session同步
        MainProcess.creditSessionSync(namespace, "1", token);
        // 实名认证
        MainProcess.realNameAuth(namespace, token);
        // 基本信息认证
        MainProcess.authBasicInfo(namespace, token);
        // 进入上传身份证页
        String ocrToken = MainProcess.enterAuthOcr(namespace, token);
        // 上传身份证正面
        MainProcess.uploadFrontOfIdCard(ocrToken);
        // 上传身份证反面
        MainProcess.uploadBackOfIdCard(ocrToken);
        // 提交拍照认证
        MainProcess.submitPhotoAuth(ocrToken);
        // 授信
        MainProcess.credit(namespace, phoneNo, userId, uuid);
        // 提交审核
        MainProcess.submitAudit(namespace, token);
        // 查询用户审核记录
        Map authResult = MainProcess.queryUserAuditRecord(namespace, userId);
        String orderNo = authResult.get("order_no").toString().trim();
        String productId = authResult.get("product_id").toString();
        // 风控授信回调
        boolean result = MainProcess.creditAuthNotify(namespace, token, uuid, channelId, fundId, orderNo, 0, auditResult, amount, term);
        return result;
    }

    /**
     * 提现
     * @param applyLoanInfo 造数据相关信息
     * @return
     * @throws Exception
     */
    @Override
    public boolean withDraw(ApplyLoanInfo applyLoanInfo) throws Exception {
        String namespace = applyLoanInfo.getNamespace();
        String phoneNo = applyLoanInfo.getPhoneNo();
        Integer channelId = applyLoanInfo.getChannel();
        Integer fundId = applyLoanInfo.getFundId();
        Integer amount = applyLoanInfo.getAmount();
        Integer term = applyLoanInfo.getTerm();

        // 登录
        String token = MainProcess.login(namespace, channelId, phoneNo);
        // 查询用户中心id
        Map map = MainProcess.checkUserId(namespace, phoneNo);
        String uuid = map.get("uuid").toString();
        String userId = map.get("id").toString();
        // 同步session到xyqb
        MainProcess.syncSessionToXyqb(namespace, token);
        // 查询用户审核记录
        Map authResult = MainProcess.queryUserAuditRecord(namespace, userId);
        String orderNo = authResult.get("order_no").toString().trim();
        String productId = authResult.get("product_id").toString();
        // 查询accountId
        Map accountMap = MainProcess.getUserAccountId(namespace, userId, productId);
        Long accountId = (Long) accountMap.get("id");
        // 绑卡
        String payToken = MainProcess.bindCard(namespace, token, accountId);
        // 绑卡发送短信
        MainProcess.cardAuthSms(namespace, payToken, phoneNo);
        // 绑卡确认
        MainProcess.cardAuthSmsConfirm(namespace, payToken);
        // 获取绑卡列表
        Map firstCard = MainProcess.getBindCardList(namespace, token, accountId);
        Integer cardId = (Integer) firstCard.get("id");
        Integer cardBindInfoId = (Integer) firstCard.get("cardBindInfoId");
        // 绑卡后提现
        Integer loanId = MainProcess.createLoan(namespace, token, amount, term, accountId, productId, cardId, cardBindInfoId);
        // 二次风控
        boolean result = MainProcess.externalQuotaOrderAuditNotify(namespace, token, uuid, loanId, 0);
        // 修改合同状态
        MainProcess.modifyContactStatus(namespace, userId);
        return result;
    }

    /**
     * 放款
     * @param applyLoanInfo
     * @return
     */
    @Override
    public boolean makeLoan(ApplyLoanInfo applyLoanInfo, boolean payStatus) throws Exception {
        String namespace = applyLoanInfo.getNamespace();
        String phoneNo = applyLoanInfo.getPhoneNo();
        Integer channelId = applyLoanInfo.getChannel();
        Integer fundId = applyLoanInfo.getFundId();
        Integer amount = applyLoanInfo.getAmount();
        Integer term = applyLoanInfo.getTerm();

        // 登录
        String token = MainProcess.login(namespace, channelId, phoneNo);
        // 查询用户中心id
        Map map = MainProcess.checkUserId(namespace, phoneNo);
        String uuid = map.get("uuid").toString();
        String userId = map.get("id").toString();

        // 登录OP，获取token
        String opToken = MainProcess.loginOP(namespace);
        // 查询待打款数量
        Map<String, Integer> peopleMap = MainProcess.checkWaitingFundingCorpOperatePeople(namespace, fundId);
        Integer money = peopleMap.get("money");
        Integer people = peopleMap.get("people");
        // 修改待放款用户创建时间
        Integer loanId = MainProcess.getLoanId(namespace, userId);
        MainProcess.modifyWaitingFundingCreatedAt(namespace, loanId);
        Thread.sleep(5000);
        // 直接打款
        MainProcess.fundsPlanLoanApply(namespace,opToken, fundId, money, people);
        Thread.sleep(30000);
        // 放款结果通知
        boolean result = MainProcess.payNotify(namespace, loanId, payStatus);
        return result;
    }

    @Override
    public boolean genLoanUser(ApplyLoanInfo applyLoanInfo) throws Exception {
        Integer status = applyLoanInfo.getStatus();

        /**
         * 0 - 审核通过
         */
        if (status == 0) {
            return quotaAuth(applyLoanInfo, true);
        }

        /**
         * 1 - 审核拒绝
         */
        if (status == 1) {
            return quotaAuth(applyLoanInfo, false);
        }

        /**
         * 2 - 放款中
         */
        if (status == 2) {
            boolean result = quotaAuth(applyLoanInfo, true);
            if (!result) {
                return false;
            }
            Thread.sleep(300000);
            return withDraw(applyLoanInfo);
        }

        /**
         * 3 - 放款成功
         */
        if (status == 3) {
            boolean quotaAuthResult = quotaAuth(applyLoanInfo, true);
            if (!quotaAuthResult) {
                return false;
            }
            Thread.sleep(300000);
            boolean withDrawResult =  withDraw(applyLoanInfo);
            if (!withDrawResult) {
                return false;
            }
            Thread.sleep(10000);
            return makeLoan(applyLoanInfo, true);
        }

        /**
         * 4 - 放款失败
         */
        if (status == 4) {
            boolean quotaAuthResult = quotaAuth(applyLoanInfo, true);
            if (!quotaAuthResult) {
                return false;
            }
            Thread.sleep(300000);
            boolean withDrawResult =  withDraw(applyLoanInfo);
            if (!withDrawResult) {
                return false;
            }
            Thread.sleep(10000);
            return makeLoan(applyLoanInfo, false);
        }
        return false;
    }


}
