package cn.qg.qaplatform.service.msg.impl;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.entity.msg.PhoneNoWhiteList;
import cn.qg.qaplatform.mapper.msg.PhoneNoWhiteListMapper;
import cn.qg.qaplatform.service.msg.PhoneNoWhiteListService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class PhoneNoWhiteListServiceImpl extends ServiceImpl<PhoneNoWhiteListMapper, PhoneNoWhiteList> implements PhoneNoWhiteListService {

    @Autowired
    PhoneNoWhiteListMapper phoneNoWhiteListMapper;

    /**
     * 判断是否在白名单，如果不在，则添加到短信白名单
     * @param namespace 环境
     * @param phoneNo 手机号
     */
    @Override
    public void handlePhoneNoWhiteList(String namespace, String phoneNo) {
        SwitchDataSource.dataSourceSwitch(namespace, "msg");
        QueryWrapper<PhoneNoWhiteList> whiteListQueryWrapper = new QueryWrapper<>();
        whiteListQueryWrapper.eq("phone_no", phoneNo);
        PhoneNoWhiteList phoneNoWhite = phoneNoWhiteListMapper.selectOne(whiteListQueryWrapper);
        if (phoneNoWhite == null) {
            log.info("该手机号不在白名单：{}，先将其添加到手机号白名单.", phoneNo);
            PhoneNoWhiteList phoneNoWhiteListEntity = new PhoneNoWhiteList();
            phoneNoWhiteListEntity.setPhoneNo(phoneNo);
            phoneNoWhiteListEntity.setUserName("测试");
            phoneNoWhiteListEntity.setListType("1");
            phoneNoWhiteListEntity.setDeleted(0);
            phoneNoWhiteListMapper.insert(phoneNoWhiteListEntity);
        } else {
            log.info("{}该手机号已在手机号白名单.", phoneNo);
        }
    }
}
