package cn.qg.qaplatform.entity.xyqb;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 贷款记录
 */
@Data
@TableName(value = "loan_application_history")
public class LoanApplicationHistory {

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * user.id
     */
    private Long userId;

    /**
     * channel.id
     */
    private Long channelId;

    /**
     * bank_card.id
     */
    private Long bankCardId;

    /**
     * 是否是当前有效的借款
     */
    private Boolean isActive;

    /**
     * 进度：0-用户未填写个人信息，1-用户未填写证件信息，2-用户未填写贷款信息，3-用户授权信息未全部完成，4-用户补充资料未完成，5-初审中，6-初审拒绝，7-终审中，8-终审拒绝，9-借款清单生成完成，10-确认借款并且去绑卡，11-放弃借款，12-绑卡完成，签订协议，13-查看还款计划
     */
    private Integer progress;

    /**
     * 创建来源
     */
    private Long createdFrom;

    /**
     * 业务类型：0-现金，1-白条
     */
    private Integer businessType;

    /**
     * 支付方式 0-易联 1-易宝
     */
    private Integer payApproach;

    /**
     * 白条merchant id
     */
    private Long baitiaoMerchantId;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 更新时间
     */
    private Date updatedAt;
}
