package cn.qg.qaplatform.entity.xyqb;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 申请额度记录表
 */
@Data
@TableName(value = "apply_quota_record")
public class ApplyQuotaRecord {

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 预留字段,客户ID
     */
    private String customerId;

    private String uuid;

    private Date applyTime;

    /**
     * 申请来源渠道
     */
    private Long applyFrom;

    /**
     * 产品ID
     */
    private Long productId;

    /**
     * 产品类型
     */
    private Integer productType;

    /**
     * 申请状态 0-发起申请风控审核中 1-风控审核拒绝 2-风控审核通过
     */
    private Integer applyStatus;

    private Date updatedAt;

    private Date createdAt;

    /**
     * 风控回调通知时间
     */
    private Date riskNotifyTime;

    /**
     * 风控申请ID(暂时使用授信中心orderNo)
     */
    private String orderNo;

    /**
     * 0-orderNo使用授信中心orderNo
     */
    private Integer applyType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 资金方出结果的时间
     */
    private Date fundResultAt;
}
