package cn.qg.qaplatform.entity.vcc;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;


/**
 * acsdb.acs_pay_order
 */
@Data
@TableName(value = "acs_pay_order")
public class AcsPayOrder {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 账户id
     */
    private Integer accountId;

    /**
     * 交易id
     */
    private Integer transId;

    /**
     * 还款类型 Repay-主动还款 Deduct-自动还款/批量扣款
     */
    private String orderType;

    /**
     * Processing - 还款处理中 Complete - 还款成功 Failed - 还款失败 New - 待处理
     */
    private String orderStatus;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 还款类型
     */
    private String repayType;

    /**
     * 支付商务流水号(易宝返回)
     */
    private String orderNo;

    /**
     * 废弃字段
     */
    private String repayOrderNo;

    /**
     * ip
     */
    private String ip;

    /**
     * 废弃字段
     */
    private String channel;

    /**
     * 废弃字段
     */
    private String sessionId;

    /**
     * 还款描述
     */
    private String repaymentDescription;

    /**
     * 废弃字段
     */
    private String divideParam;

    /**
     * 还款时间戳(毫秒)
     */
    private String repaidAt;

    /**
     * 流水号(内部生成)
     */
    private String businessFlowNo;

    /**
     * 电话号
     */
    private String phone;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 姓名
     */
    private String name;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行卡号(后4位)
     */
    private String bankCardNo;

    /**
     * 支付中心绑卡编号
     */
    private Integer payCenterCardId;

    /**
     * 废弃字段
     */
    private String chargeType;

    /**
     * 扩展字段
     */
    private String extData;

    /**
     * 响应码(支付中心)
     */
    private String respCode;

    /**
     * 响应信息(支付中心)
     */
    private String respMsg;

    /**
     * 待还账单编号(acs_bill主键id)
     */
    private Integer repayBillId;

    /**
     * 还款类型 C 全额还款 P 部分还款 O 逾期还款 F 提前还款
     */
    private String commandFlag;

    /**
     * 对账状态 Has(已对账)/null(未对账)
     */
    private String accountingStatus;

    /**
     * 版本
     */
    private Integer version;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 账单no
     */
    private String repayBillNo;
}
