package cn.qg.qaplatform.controller;

import cn.qg.qaplatform.common.JsonResult;
import cn.qg.qaplatform.common.enums.ChannelEnum;
import cn.qg.qaplatform.common.enums.FundEnum;
import cn.qg.qaplatform.domain.ApplyLoanInfo;
import cn.qg.qaplatform.service.GenUserDataService;
import cn.qg.qaplatform.service.QueryBasicLoanStatusDataService;
import cn.qg.qaplatform.utils.EnumUtils;
import cn.qg.qaplatform.utils.RandomDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@CrossOrigin
@RequestMapping("/gen")
public class GenLoanUserDataController {

    @Autowired
    GenUserDataService genUserDataService;

    @Autowired
    QueryBasicLoanStatusDataService queryBasicLoanStatusDataService;

    @PostMapping("/loanUser")
    public JsonResult genLoanUserData(@RequestBody ApplyLoanInfo applyLoanInfo) throws Exception {
        if (applyLoanInfo.getNamespace() == null) {
            return JsonResult.clientFailed("namespace不能为空！");
        }
        if (applyLoanInfo.getChannel() == null) {
            return JsonResult.clientFailed("渠道不能为空！");
        }
        if (applyLoanInfo.getStatus() == null) {
            return JsonResult.clientFailed("借款状态不能为空！");
        }
        // 如果手机号为空，则生成一个user库里没有的手机号
        if (applyLoanInfo.getPhoneNo() == null) {
            while (true) {
                String phoneNo = RandomDataUtils.createMobile();
                if (!queryBasicLoanStatusDataService.queryIfPhoneExist(applyLoanInfo.getNamespace(), phoneNo)) {
                    applyLoanInfo.setPhoneNo(phoneNo);
                    break;
                }
            }
        }
        if (applyLoanInfo.getAmount() == null) {
            applyLoanInfo.setAmount(10000);
        }
        if (applyLoanInfo.getTerm() == null) {
            applyLoanInfo.setTerm(6);
        }
        boolean result = genUserDataService.genLoanUser(applyLoanInfo);
        return JsonResult.success(result);
    }

    @GetMapping("/supportChannelAndFund")
    public JsonResult getSupportedLoanUserData() {
        Map<String, List> map = new HashMap();
        List supportChannel = EnumUtils.enumToListMap(ChannelEnum.class);
        List supportFund = EnumUtils.enumToListMap(FundEnum.class);
        map.put("channelList", supportChannel);
        map.put("fundList", supportFund);
        return JsonResult.success(map);
    }

}
