package cn.qg.qaplatform.process;

import cn.qg.qaplatform.config.WebSocketServer;
import cn.qg.qaplatform.entity.zdata.XyqbApplyDataVo;
import cn.qg.qaplatform.encrypt.LexinEncrypt;
import cn.qg.qaplatform.utils.HttpClientUtils;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * 乐信
 * @author libo
 */
@Slf4j
public class Lexin {
    public static String MD5Keywy = "qEAxMJBv";
    public static String AESKeywy = "sxD8KO79EDK0N0AJ";
    public static Random random = new Random();

    /**
     * 进件
     */
    public static boolean createOrder(XyqbApplyDataVo xyqbApplyDataVo) {
        String namespace = xyqbApplyDataVo.getNamespace();
        String phoneNo = xyqbApplyDataVo.getPhoneNo();
        String userName = xyqbApplyDataVo.getName();
        String idCardNo = xyqbApplyDataVo.getIdCardNo();
        Integer amount = xyqbApplyDataVo.getAmount();
        Integer term = xyqbApplyDataVo.getTerm();
        String rate = xyqbApplyDataVo.getRate();
        String fixedBillDay = xyqbApplyDataVo.getFixedBillDay();
        String fixedRepayDay = xyqbApplyDataVo.getFixedRepayDay();
        String symbol = xyqbApplyDataVo.getSymbol();

        String orderNo = "channel_order" + phoneNo + "_" + random.nextInt(9999);
        String url = "http://qapi-" + namespace + ".liangkebang.net/ex/api/v2/applyLoan/LEXIN";
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("orderNo", orderNo);
        bizData.put("userName", userName);
        bizData.put("idCardNo", idCardNo);
        bizData.put("phone", phoneNo);
        bizData.put("qq", "123456");
        bizData.put("email", "2222@qq.com");
        bizData.put("address", "北京");
        bizData.put("addressLocation", "浙江省绍兴市");
        bizData.put("addrDetail", "大鹿庄村1号");
        bizData.put("channelUserId", phoneNo);
        bizData.put("districtCode", "110101");
        bizData.put("workUnit", "北京市测试公司");
        bizData.put("industry", "TRAFFIC");
        bizData.put("loanDemandPurpose", "FURNITURE_HOME");
        List<Map> creditList = createCreditList();
        bizData.put("creditList", creditList);
        bizData.put("education", "MASTER");
        bizData.put("occupation", "UNEMPLOYED");
        bizData.put("income", "CASH_AND_PAY_CARD");
        bizData.put("incomeRange", "BELOW_3000");
        bizData.put("marryStatus", "MARRIED");
        bizData.put("hasCar", true);
        bizData.put("hasCreditCard", true);
        bizData.put("hasHouse", true);
        bizData.put("hasSocialSecurity", true);
        bizData.put("emergencyContactNameA", "测试联系人一");
        bizData.put("emergencyContactPhoneA", "18666666665");
        bizData.put("emergencyContactRelationA", "SPOUSE");
        bizData.put("emergencyContactNameB", "测试联系人二");
        bizData.put("emergencyContactPhoneB", "18066666666");
        bizData.put("emergencyContactRelationB", "FRIEND");
        Map<String, Object> authInfo = createAuthInfo(idCardNo, userName);
        Map<String, Object> scenarioData = createScenarioData(amount, term, rate, fixedBillDay, fixedRepayDay);
        Map<String, Object> orderInfoExtend = new HashMap<>();
        orderInfoExtend.put("creditContractTime", "2020-08-28 09:48:23");
        bizData.put("authInfo", authInfo);
        bizData.put("scenarioData", scenarioData);
        bizData.put("orderInfoExtend", orderInfoExtend);
        String bizDataStr = JSONObject.toJSONString(bizData);
        String signStr = DigestUtils.md5DigestAsHex((bizDataStr + MD5Keywy).getBytes());
        Map<String, Object> content = new HashMap<>();
        content.put("sign", signStr);
        content.put("bizData", bizDataStr);
        log.info("进件参数为：" + content);
        if (!StringUtils.isEmpty(symbol)) {
            WebSocketServer.sendInfo("进件参数为：{}" + content.toString(), symbol);
        }
        String contentStr = LexinEncrypt.encryptAndBase64Encode(JSONObject.toJSONString(content), AESKeywy);

        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        JSONObject result = HttpClientUtils.doPost(url, "content=" + contentStr);
        String response = LexinEncrypt.decryptAfterBase64Decode(result.get("content").toString(), AESKeywy);
        log.info("乐信进件返回结果: {}", JSONObject.parseObject(response).toString());
        if (!StringUtils.isEmpty(symbol)) {
            WebSocketServer.sendInfo("进件返回结果为：" + response, symbol);
        }
        return true;
    }

    public static Map<String, Object> createAuthInfo(String idCardNo, String userName) {
        Map<String, Object> authInfo = new HashMap<>();
        Map<String, Object> ocr = new HashMap<>();
        ocr.put("address", "浙江省绍兴市市辖区飞双村6号院57号楼2门509");
        ocr.put("agency", "绍兴市公安局");
        ocr.put("citizen_id", idCardNo);
        ocr.put("gender", "女");
        ocr.put("idCardBaseContentA", "OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9");
        ocr.put("idCardBaseContentB", "OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9");
        ocr.put("livePhotoContent", "OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9OWJZWU81MkRmeTI1bCtGaGxFL3hBUndjb3I0MUQ0YzZVTEZwZkdRM1VRREFxUDJBR1RnZVdVa3lxRVFmRVpSTlZuUm5XZ3FjSUJ1VWFlTmV5cGMvSW5meFRLR1cvUWNXRWZXejhSeDNCNWs9");
        ocr.put("name", userName);
        ocr.put("nation", "壮");
        ocr.put("picModel", "2");
        ocr.put("valid_date_begin", "20150908");
        ocr.put("valid_date_end", "20250908");
        ocr.put("liveType", "face");
        Map<String, Object> result_idcard_photo = new HashMap<>();
        result_idcard_photo.put("confidence", 82.584);
        Map<String, Double> thresholds = new HashMap<>();
        thresholds.put("1e-3", 62.169);
        thresholds.put("1e-5", 74.399);
        thresholds.put("1e-4", 69.315);
        thresholds.put("1e-6", 78.038);
        result_idcard_photo.put("thresholds", thresholds);
        ocr.put("result_idcard_photo", result_idcard_photo);
        authInfo.put("ocr", ocr);
        return authInfo;
    }

    public static Map<String, Object> createScenarioData(Integer amount, Integer term, String rate, String fixedBillDay, String fixedRepayDay) {
        Map<String, Object> scenarioData = new HashMap<>();
        Map<String, Object> auditInfo = new HashMap<>();
        Map<String, Object> extra = new HashMap<>();
        auditInfo.put("auditAmount", amount);
        auditInfo.put("auditTerm", term);
        auditInfo.put("rate", rate);
        auditInfo.put("fixedBillDay", fixedBillDay);
        auditInfo.put("fixedRepayDay", fixedRepayDay);
        extra.put("orderType", "取现");
        scenarioData.put("auditInfo", auditInfo);
        scenarioData.put("extra", extra);
        return scenarioData;
    }

    public static List createCreditList() {
        List<Map<String, String>> creditList = new ArrayList<>();
        Map<String, String> map = new HashMap<>();
        map.put("name", "OCR");
        map.put("organization", "1");
        creditList.add(map);
        return creditList;
    }
}
