package cn.qg.qaplatform.config;

import cn.qg.qaplatform.enums.Namespace;
import com.alibaba.druid.pool.DruidDataSource;


/**
 * 切换数据源
 * @author libo
 */
public class SwitchDataSource {

    public static final String SUFFIX = "?characterEncoding=utf-8&useSSL=false&serverTimezone=UTC&useAffectedRows=true";

    public static void dataSourceSwitch(String namespace, String database) {

        /**
         * dev1环境
         */
        if (namespace.equals("dev1")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.DEV1.getUrl() + database + SUFFIX;
            String dbKey = Namespace.DEV1.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.DEV1.getUsername());
            druidDataSource.setPassword(Namespace.DEV1.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * pre 环境
         */
        if (namespace.equals("ka1")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.KA1.getUrl() + database + SUFFIX;
            String dbKey = Namespace.KA1.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.KA1.getUsername());
            druidDataSource.setPassword(Namespace.KA1.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * qa 环境
         */
        if (namespace.equals("qa")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.QA.getUrl() + database + SUFFIX;
            String dbKey = Namespace.QA.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.QA.getUsername());
            druidDataSource.setPassword(Namespace.QA.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * qa2 环境
         */
        if (namespace.equals("qa2")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.QA2.getUrl() + database + SUFFIX;
            String dbKey = Namespace.QA2.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.QA2.getUsername());
            druidDataSource.setPassword(Namespace.QA2.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * qa3 环境
         */
        if (namespace.equals("qa3")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.QA3.getUrl() + database + SUFFIX;
            String dbKey = Namespace.QA3.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.QA3.getUsername());
            druidDataSource.setPassword(Namespace.QA3.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * test1 环境
         */
        if (namespace.equals("test1")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.TEST1.getUrl() + database + SUFFIX;
            String dbKey = Namespace.TEST1.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.TEST1.getUsername());
            druidDataSource.setPassword(Namespace.TEST1.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * test2 环境
         */
        if (namespace.equals("test2")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.TEST2.getUrl() + database + SUFFIX;
            String dbKey = Namespace.TEST2.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.TEST2.getUsername());
            druidDataSource.setPassword(Namespace.TEST2.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * test3 环境
         */
        if (namespace.equals("test3")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.TEST3.getUrl() + database + SUFFIX;
            String dbKey = Namespace.TEST3.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.TEST3.getUsername());
            druidDataSource.setPassword(Namespace.TEST3.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * test5 环境
         */
        if (namespace.equals("test5")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.TEST5.getUrl() + database + SUFFIX;
            String dbKey = Namespace.TEST5.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.TEST5.getUsername());
            druidDataSource.setPassword(Namespace.TEST5.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * xjfq 环境
         */
        if (namespace.equals("xjfq")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.XJFQ.getUrl() + database + SUFFIX;
            String dbKey = Namespace.XJFQ.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.XJFQ.getUsername());
            druidDataSource.setPassword(Namespace.XJFQ.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * xyqb 环境
         */
        if (namespace.equals("xyqb")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.XYQB.getUrl() + database + SUFFIX;
            String dbKey = Namespace.XYQB.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.XYQB.getUsername());
            druidDataSource.setPassword(Namespace.XYQB.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * fe 环境
         */
        if (namespace.equals("fe")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.FE.getUrl() + database + SUFFIX;
            String dbKey = Namespace.FE.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.FE.getUsername());
            druidDataSource.setPassword(Namespace.FE.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * vcc环境
         */
        if (namespace.equals("vcc")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.VCC.getUrl() + database + SUFFIX;
            String dbKey = Namespace.VCC.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.VCC.getUsername());
            druidDataSource.setPassword(Namespace.VCC.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * vcc2环境
         */
        if (namespace.equals("vcc2")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.VCC2.getUrl() + database + SUFFIX;
            String dbKey = Namespace.VCC2.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.VCC2.getUsername());
            druidDataSource.setPassword(Namespace.VCC2.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * vcc3环境
         */
        if (namespace.equals("vcc3")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.VCC3.getUrl() + database + SUFFIX;
            String dbKey = Namespace.VCC3.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.VCC3.getUsername());
            druidDataSource.setPassword(Namespace.VCC3.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * TOB环境
         */
        if (namespace.equals("tob")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.TOB.getUrl() + database + SUFFIX;
            String dbKey = Namespace.TOB.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.TOB.getUsername());
            druidDataSource.setPassword(Namespace.TOB.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }
    }
}
