package cn.qg.qaplatform.config;

import com.alibaba.druid.pool.DruidDataSource;

import java.util.Map;


/**
 * 切换数据源
 * @author libo
 */
public class SwitchDataSource {

    public static final String SUFFIX = "?characterEncoding=utf-8&useSSL=false&serverTimezone=UTC&useAffectedRows=true";

    public static void dataSourceSwitch(String namespace, String database) {

        Map<String, String> nsMap = NamespaceCache.namespaceMap;

        String dbUrl = nsMap.get(namespace);
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUrl("jdbc:mysql://" + dbUrl + "/" + database + SUFFIX);
        druidDataSource.setUsername("qa");
        druidDataSource.setPassword("qatest");
        DynamicDataSource.dataSourcesMap.put(namespace, druidDataSource);
        DynamicDataSource.setDataSource(namespace);

    }
}
