package cn.qg.qaplatform.automation.controller;

import cn.qg.qaplatform.automation.domain.Project;
import cn.qg.qaplatform.automation.service.ProjectService;
import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.utils.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@CrossOrigin
@RestController
@RequestMapping("/project")
public class ProjectController {
    @Autowired
    ProjectService projectService;

    @GetMapping("/list")
    public JsonResult getProjectList() {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(projectService.list());
    }

    @PostMapping("/add")
    public JsonResult addProject(@RequestBody Project project) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(projectService.save(project));
    }

    @PostMapping("/update")
    public JsonResult updateProject(@RequestBody Project project) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(projectService.updateById(project));
    }

    @GetMapping("/delete")
    public JsonResult deleteProject(Integer id) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(projectService.removeById(id));
    }
}
