package cn.qg.qaplatform.controller.zdata.vcc;

import cn.qg.qaplatform.utils.JsonResult;
import cn.qg.qaplatform.enums.VccStatusEnum;
import cn.qg.qaplatform.entity.zdata.VccUserEntity;
import cn.qg.qaplatform.service.zdata.vcc.VccDataService;
import cn.qg.qaplatform.utils.page.PageResult;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@CrossOrigin
@Api(tags = "vcc查询")
@RestController
@RequestMapping("/vcc")
public class VccQueryController {

    @Autowired
    VccDataService vccDataService;

    @GetMapping("/getData")
    public JsonResult getVccData(@RequestParam(value = "namespace") String namespace,
                                 @RequestParam(value = "status") Integer status,
                                 @RequestParam(defaultValue = "1") Integer pageNum,
                                 @RequestParam(defaultValue = "10") Integer pageSize) {
        PageResult vccData = vccDataService.getVccData(namespace, status, pageNum, pageSize);
        return JsonResult.success(vccData);
    }

    @GetMapping("/getStatus")
    public JsonResult getUserStatus(String namespace, String phoneNo) {
        VccUserEntity vccUserEntity = vccDataService.queryUserVccStatus(namespace, phoneNo);
        if (vccUserEntity == null) {
            return JsonResult.serverFailed("该用户不存在！");
        }
        return JsonResult.success(vccUserEntity);
    }

    @GetMapping("/checkData")
    public JsonResult checkUserData(String namespace, String phoneNo) {
        VccUserEntity vccUserEntity = vccDataService.queryUserVccStatus(namespace, phoneNo);
        if (vccUserEntity == null) {
            return JsonResult.serverFailed("该用户不存在！");
        }
        Map<String, Object> map = new HashMap<>();
        map.put("phoneNo", vccUserEntity.getPhoneNo());
        map.put("userId", vccUserEntity.getUserId());
        map.put("uuid", vccUserEntity.getUuid());
        map.put("registeredFrom", vccUserEntity.getRegisteredFrom());
        map.put("nextApplyTime", vccUserEntity.getNextApplyTime());
        map.put("createdAt", vccUserEntity.getCreatedAt());
        map.put("status", VccStatusEnum.getDescByCode(vccUserEntity.getStatus()));
        return JsonResult.success(map);
    }
}
