package cn.qg.qaplatform.zdata.service.impl;

import cn.qg.qaplatform.zdata.domain.QueryLoanUser;
import cn.qg.qaplatform.zdata.service.QueryLoanUserDataService;
import cn.qg.qaplatform.zdata.service.QueryBasicLoanStatusDataService;
import cn.qg.qaplatform.utils.page.PageResult;
import cn.qg.qaplatform.utils.page.PageUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 查询旧有数据
 */
@Service
@Slf4j
public class QueryLoanUserDataServiceImpl implements QueryLoanUserDataService {

    @Autowired
    private QueryBasicLoanStatusDataService basicLoanStatusDataService;

    /**
     * 筛选某个状态的用户（0-注册未申请，1-授信中，2-审核通过，3-审核拒绝，4-审核通过未提现，5-放款成功，6-放款失败，7-多订单）
     *
     * @param namespace 环境
     * @param status    用户状态
     * @param channel   渠道id
     * @param fundId    资方id
     * @return
     */
    @Override
    public PageResult getLoanUserData(String namespace, Integer status, Integer channel, Integer fundId, Integer pageNum, Integer pageSize) {

        List<QueryLoanUser> result = new ArrayList<>();

        /**
         * 0-注册未申请
         */
        if (status == 0) {
            List<String> uuidList = basicLoanStatusDataService.getUnApplyUserUuidList(namespace, channel);
            if (uuidList.isEmpty()) {
                log.info("渠道:" + channel + "【注册未申请】的人数为空！");
                return null;
            }
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUuidList(namespace, uuidList);
            PageInfo<QueryLoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 1-授信中
         */
        if (status == 1) {
            List<String> userIdList = basicLoanStatusDataService.getAuditStatusUserIdList(namespace, 0, channel);
            if (userIdList.isEmpty()) {
                log.info(namespace + "环境，" + "渠道:" + channel + "【授信中】的人数为空！");
                return null;
            }
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            PageInfo<QueryLoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 2-审核通过
         */
        if (status == 2) {
            List<String> userIdList = basicLoanStatusDataService.getAuditStatusUserIdList(namespace, 2, channel);
            if (userIdList.isEmpty()) {
                log.info(namespace + "环境，" + "渠道:" + channel + "【审核通过】的人数为空！");
                return null;
            }
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            if (fundId == null) {
                result.forEach((item) -> item.setFundId(basicLoanStatusDataService.getAssignFundIdByUserId(namespace, item.getUserId())));
            } else {
                result.forEach((item) -> item.setFundId(fundId));
            }
            PageInfo<QueryLoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 3-审核拒绝
         */
        if (status == 3) {
            List<String> userIdList = basicLoanStatusDataService.getAuditStatusUserIdList(namespace, 1, channel);
            if (userIdList.isEmpty()) {
                log.info(namespace + "环境，" + "渠道:" + channel + "【审核拒绝】的人数为空！");
                return null;
            }
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            if (fundId == null) {
                result.forEach((item) -> item.setFundId(basicLoanStatusDataService.getAssignFundIdByUserId(namespace, item.getUserId())));
            } else {
                result.forEach((item) -> item.setFundId(fundId));
            }
            PageInfo<QueryLoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 4-审核通过未提现
         */
        if (status == 4) {
            List<String> userIdList = basicLoanStatusDataService.queryAuthAndUnWithdraw(namespace, channel, fundId);
            if (userIdList.isEmpty()) {
                log.info(namespace + "环境，" + "渠道：" + channel + ", 资方：" + fundId + "【审核通过未提现】的人数为空！");
                return null;
            }
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            result.forEach((item) -> item.setFundId(fundId));
            PageInfo<QueryLoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 5-放款成功
         */
        if (status == 5) {
            List<String> userIdList = basicLoanStatusDataService.getLoanStatusUserIdList(namespace, 1, channel, fundId);
            if (userIdList.isEmpty()) {
                log.info(namespace + "环境，" + "渠道：" + channel + ", 资方：" + fundId + "【放款成功】的人数为空！");
                return null;
            }
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            if (fundId == null) {
                result.forEach((item) -> item.setFundId(basicLoanStatusDataService.getAssignFundIdByUserId(namespace, item.getUserId())));
            } else {
                result.forEach((item) -> item.setFundId(fundId));
            }
            PageInfo<QueryLoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 6-放款失败
         */

        if (status == 6) {
            List<String> userIdList = basicLoanStatusDataService.getLoanStatusUserIdList(namespace, 0, channel, fundId);
            if (userIdList.isEmpty()) {
                log.info(namespace + "环境，" + "渠道：" + channel + ", 资方：" + fundId + "【放款失败】的人数为空！");
                return null;
            }
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            if (fundId == null) {
                result.forEach((item) -> item.setFundId(basicLoanStatusDataService.getAssignFundIdByUserId(namespace, item.getUserId())));
            } else {
                result.forEach((item) -> item.setFundId(fundId));
            }
            PageInfo<QueryLoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 7-多订单白名单
         */
        if (status == 7) {
            List<String> uuidList = basicLoanStatusDataService.getMultiOrderUserDataList(namespace);
            if (uuidList.isEmpty()) {
                log.info(namespace + "环境，多订单白名单的用户数为0！");
                return null;
            }
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUuidList(namespace, uuidList);
            PageInfo<QueryLoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }
        log.info("status=" + status + "状态不存在！");
        return null;
    }
}
