package cn.qg.qaplatform.controller.zdata.vcc;

import cn.qg.qaplatform.utils.JsonResult;
import cn.qg.qaplatform.entity.zdata.VccOpenResultVo;
import cn.qg.qaplatform.service.zdata.vcc.VccDataService;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@CrossOrigin
@RestController
@RequestMapping("vcc")
@Api(tags = "vcc造数据")
public class VccGenController {

    @Autowired
    VccDataService vccDataService;

    @PostMapping("/gen")
    @ApiOperation(value = "vcc造数据")
    public JsonResult genVccUser(@RequestParam(value = "namespace") String namespace,
                                 @RequestParam(value = "phoneNo") String phoneNo,
                                 @RequestParam(value = "channel") String channel,
                                 @RequestParam(value = "status") Integer status) throws Exception {
        if (status !=1 && status !=2 && status !=3 && status !=4) {
            return JsonResult.clientFailed("状态值必须是1、2、3、4中的一个！");
        }
        VccOpenResultVo result = vccDataService.makeVccUser(namespace, phoneNo, channel, status);
        if (result == null) {
            return JsonResult.serverFailed();
        }
        return JsonResult.success(result);
    }

    /**
     * vcc授信回调简单版本
     * @param namespace 环境
     * @param phoneNo 手机号
     * @param result 结果
     * @param amount 金额
     * @return
     */
    @GetMapping("/risk")
    public JsonResult vccRiskControl(String namespace, String phoneNo, Boolean result, Integer amount)  {
        if (amount == null) {
            amount = 10000;
        }
        return JsonResult.success(vccDataService.vccManualRiskControl(namespace, phoneNo, result, amount));
    }

    @GetMapping("/repay/callback")
    public JsonResult vccRepayCallback(String namespace, String phoneNo, Integer result) {
        JSONObject response = vccDataService.vccRepayCallback(namespace, phoneNo, result);
        return JsonResult.success(response);
    }

}
