package cn.qg.qaplatform.service.impl;

import cn.qg.qaplatform.domain.GenVccUser;
import cn.qg.qaplatform.process.Vcc;
import cn.qg.qaplatform.service.VccDataService;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import java.util.Map;


@Service
public class VccDataServiceImpl implements VccDataService {

    /**
     * @param namespace
     * @param phoneNo
     * @param openedChannel
     * @param status 0-未激活，1-已激活
     * @return
     * @throws Exception
     */
    @Override
    public GenVccUser makeVccUser(String namespace, String phoneNo, String openedChannel, Integer status) throws Exception {
        GenVccUser genVccUser = new GenVccUser();
        genVccUser.setPhoneNo(phoneNo);
        genVccUser.setOpenedChannel(openedChannel);
        String vccChannel = null;
        if (openedChannel.equals("214")) {
            vccChannel = "159904";
        } else if (openedChannel.equals("217")) {
            vccChannel = "159905";
        }
        if (vccChannel == null) {
            return null;
        }
        // 登录
        Map loginResult = Vcc.login(namespace, phoneNo, openedChannel, openedChannel);
        String token = loginResult.get("token").toString();
        String uuid = loginResult.get("uuid").toString();
        // credit url
        String vccToken = Vcc.creditUrl(namespace, token, vccChannel);
        // 身份证正面
        Vcc.uploadFrontIdCard(vccToken, uuid, vccChannel);
        // 身份证反面
        Vcc.uploadBackIdCard(vccToken, uuid, vccChannel);
        // 放置身份证重复
        Vcc.modifyExistIdNo(namespace);
        // talos保存用户信息
        Vcc.saveUserDetails(namespace, token, vccChannel);
        // 提交ocr
        Vcc.submitOcr(vccToken, vccChannel);
        // 提交授信
        Vcc.submitCredit(namespace, token, vccChannel);
        // 授信结果查询
        Vcc.searchCreditResult(namespace, token, vccChannel);
        if (status == 0) {
            return genVccUser;
        }
        if (status == 1) {
            // 人脸识别回调
            Vcc.appFaceCallback(namespace, token, vccChannel);
            // 基本信息
            Vcc.basicInfo(namespace, token, vccChannel);
            // 发送验证码
            String requestId = Vcc.bindCardSms(namespace, token, vccChannel, "ABC", "6228272537046278993");
            // 额度激活
            Vcc.quotaActivation(namespace, token, vccChannel, "6228272537046278993", requestId);
            // 开户结果
            JSONObject result = Vcc.openResult(namespace, token, vccChannel);
            Map data = (Map) result.get("data");
            String amount = data.get("amount").toString();
            String eacctNo = data.get("eacctNo").toString();
            genVccUser.setAmount(amount);
            genVccUser.setEacctNo(eacctNo);
        }
        return genVccUser;
    }
}
