package cn.qg.qaplatform.utils;

import lombok.Data;

import java.io.Serializable;

@Data
public class Result<T> implements Serializable {

    private static final Long SUCCESS_CODE = 0L;

    private static final String SUCCESS_MSG = "SUCCESS";

    private static final Long ERROR_STATE_CODE = 1L;

    private static final Long SUCCESS_BUSSINESS_CODE = 0L;

    private static final Long ERROR_BUSSINESS_CODE = 1L;

    private static final long serialVersionUID = -1L;

    public static final Long API_INVOKE_UNEXPECTED_RESULT_CODE = 2L;

    public static final String ZERO_FILL_TEMPLATE = "%04d";

    private String msg = "";

    // 0成功，1失败
    private String code = "0000";

    // 业务错误码
    private String businessCode = "0000";
    // 业务状态码
    private String businessFlag = "0000";
    private Object data = null;

    public Result() {
    }

    /**
     * @param msg
     * @param code
     * @param data
     */
    public Result(String msg, Long code, Object data) {
        this.msg = msg;
        this.code = String.format(ZERO_FILL_TEMPLATE, code);
        this.data = data;
    }

    public Result(String msg, Long code, Object data, Long businessCode) {
        this.msg = msg;
        this.code = String.format(ZERO_FILL_TEMPLATE, code);
        this.data = data;
        this.businessCode = String.format(ZERO_FILL_TEMPLATE, businessCode);
    }

    public Result(String msg, Long code, Object data, Long businessFlag, Long businessCode) {
        this.msg = msg;
        this.code = String.format(ZERO_FILL_TEMPLATE, code);
        this.data = data;
        this.businessCode = String.format(ZERO_FILL_TEMPLATE, businessCode);
        this.businessFlag = String.format(ZERO_FILL_TEMPLATE, businessFlag);
    }

    /**
     * 构造成功的Result
     *
     * @param msg  String
     * @param data Object
     * @return Result
     */
    public static Result buildSuccessResult(String msg, Object data) {
        return new Result(msg, SUCCESS_CODE, data, SUCCESS_BUSSINESS_CODE);
    }

    public static Result buildSuccessResult(Object data) {
        return new Result(SUCCESS_MSG, SUCCESS_CODE, data, SUCCESS_BUSSINESS_CODE);
    }

    public static Result buildSuccessResult(String msg, Object data, Long bussinessId) {
        return new Result(msg, SUCCESS_CODE, data, bussinessId);
    }

    public static Result buildSuccessResult(String msg, Object data, Long businessFlag, Long bussinessCode) {
        return new Result(msg, SUCCESS_CODE, data, businessFlag, bussinessCode);
    }

    /**
     * 构造状态不正确的Result
     *
     * @param msg  String
     * @param data Object
     * @return Result
     */
    public static Result buildErrorStateResult(String msg, Object data) {
        return new Result(msg, SUCCESS_CODE, data, ERROR_BUSSINESS_CODE);
    }

    public static Result buildErrorStateResult(String msg, Object data, Long busniessId) {
        return new Result(msg, SUCCESS_CODE, data, busniessId);
    }

    public static Result buildFatalErrorStateResult(String msg, Object data, Long busniessId) {
        return new Result(msg, ERROR_STATE_CODE, data, busniessId);
    }

    public static Result buildFatalErrorStateResult(String msg, Object data) {
        return new Result(msg, ERROR_STATE_CODE, data, 1L);
    }

    public static Result buildApiInvokeUnexpectedResult(String msg, Object data) {
        return new Result(msg, SUCCESS_CODE, data, API_INVOKE_UNEXPECTED_RESULT_CODE);
    }

    public Result(Object data) {
        this.data = data;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public String getBusinessFlag() {
        return businessFlag;
    }

    public void setBusinessFlag(String businessFlag) {
        this.businessFlag = businessFlag;
    }

    @Override
    public String toString() {
        return "Result{" + "businessCode='" + businessCode + '\'' + ", code='" + code + '\'' + ", data=" + data
                + ",businessFlag=" + businessFlag + '}';
    }

    public boolean isSuccess() {
        return "0000".equals(code) && "0000".equals(businessCode);
    }
}
