package cn.quantgroup.qaplatform.service.impl;

import cn.quantgroup.qaplatform.config.DynamicDataSource;
import cn.quantgroup.qaplatform.domain.LoanUser;
import cn.quantgroup.qaplatform.service.QueryBasicLoanStatusDataService;
import cn.quantgroup.qaplatform.service.QueryLoanUserDataService;
import cn.quantgroup.qaplatform.utils.RandomDataUtils;
import cn.quantgroup.qaplatform.utils.page.PageResult;
import cn.quantgroup.qaplatform.utils.page.PageUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 查询旧有数据
 */
@Service
public class QueryLoanUserDataServiceImpl implements QueryLoanUserDataService {

    @Autowired
    private QueryBasicLoanStatusDataService basicLoanStatusDataService;

    /**
     * 筛选某个状态的用户（0-注册未申请，1-授信中，2-审核通过，3-审核拒绝，4-审核通过未提现，5-放款成功，6-放款失败，7-多订单）
     * @param namespace 环境
     * @param status 用户状态
     * @param channel 渠道id
     * @param fundId 资方id
     * @return
     */
    @Override
    public PageResult getLoanUserData(String namespace, Integer status, Integer channel, Integer fundId, Integer pageNum, Integer pageSize) {

        List<LoanUser> result = new ArrayList<>();

        /**
         * 0-注册未申请
         */
        if (status == 0) {
            List<String> uuidList = basicLoanStatusDataService.getUnApplyUserUuidList(namespace, channel);
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUuidList(namespace, uuidList);
            PageInfo<LoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 1-授信中
         */
        if (status == 1) {
            List<String> userIdList = basicLoanStatusDataService.getAuditStatusUserIdList(namespace, 0, channel);
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            PageInfo<LoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 2-审核通过
         */
        if (status == 2) {
            List<String> userIdList = basicLoanStatusDataService.getAuditStatusUserIdList(namespace, 2, channel);
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            PageInfo<LoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 3-审核拒绝
         */
        if (status == 3) {
            List<String> userIdList = basicLoanStatusDataService.getAuditStatusUserIdList(namespace, 1, channel);
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            result.forEach((item)->item.setFundId(fundId));
            PageInfo<LoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 4-审核通过未提现
         */
        if (status == 4) {
            List<String> userIdList = basicLoanStatusDataService.queryAuthAndUnWithdraw(namespace, channel, fundId);
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            result.forEach((item)->item.setFundId(fundId));
            PageInfo<LoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 5-放款成功
         */
        if (status == 5) {
            List<String> userIdList = basicLoanStatusDataService.getLoanStatusUserIdList(namespace, 1, channel, fundId);
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            result.forEach((item)->item.setFundId(fundId));
            PageInfo<LoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 6-放款失败
         */

        if (status == 6) {
            List<String> userIdList = basicLoanStatusDataService.getLoanStatusUserIdList(namespace, 0, channel, fundId);
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUserIdList(namespace, userIdList);
            result.forEach((item)->item.setFundId(fundId));
            PageInfo<LoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }

        /**
         * 7-多订单
         */
        if (status == 7) {
            List<String> uuidList = basicLoanStatusDataService.getMultiOrderUserDataList(namespace);
            if (uuidList.isEmpty()) {
                return null;
            }
            PageHelper.startPage(pageNum, pageSize);
            result = basicLoanStatusDataService.getUserDataListByUuidList(namespace, uuidList);
            PageInfo<LoanUser> pageList = new PageInfo<>(result);
            PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
            return pageResult;
        }
        return null;
    }

    /**
     * 清除数据源并重置为默认数据源
     * @throws Throwable
     */
    protected void finalize() throws Throwable {
        super.finalize();
        DynamicDataSource.clear();
    }
}
