package cn.qg.qaplatform.entity.vcc;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * vcc_talos.account
 */
@Data
@TableName("account")
public class Account {

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * user.id
     */
    private Long userId;

    /**
     * user.uuid
     */
    private String uuid;

    /**
     * user.registered_from
     */
    private Long registeredFrom;

    /**
     * 支付密码
     */
    private String payPwd;

    /**
     * 支付密码salt
     */
    private String payPwdSalt;

    /**
     * 账户状态：0-初始状态，1-激活成功，2-激活失败，3-禁用，4-审核中
     */
    private Integer status;

    /**
     * 进度：0-用户未完成OCR、10-用户活体未完成、20-运营商授权未完成、30-用户相关联系人未完成、36-用户未确认激活、40-激活必要的用户授权信息完成、50-审核中、51-审核拒绝、60-未设置交易密码、70-绑卡未完成、80-绑卡完成
     */
    private Integer progress;

    /**
     * 是否提额完成
     */
    private Integer quotaUpFinished;

    /**
     * 账单日，-1: 月末
     */
    private Integer billDay;

    /**
     * 还款日
     */
    private Integer repayDay;

    /**
     * 风控通知时间
     */
    private Date riskNotifyTime;

    /**
     * 下次可申请激活时间
     */
    private Date nextApplyTime;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 更新时间
     */
    private Date updatedAt;

    /**
     * 电话号
     */
    private String phoneNo;

    /**
     * VCC用户注册渠道.ps:registered_from是用户中心的注册渠道
     */
    private Long registeredChannel;

    /**
     * VCC用户注册子渠道
     */
    private Long sonRegisteredChannel;

    private String phoneHash;

    /**
     * 完成授信时的渠道
     */
    private Long endChannel;

    /**
     * 是否存在XYQB现金额度
     */
    private Integer cashQuotaStatus;

    /**
     * 账号类别：vcc(C端虚拟信用卡)/scacard(企业信用卡)
     */
    private String type;

    /**
     * 0 - 正常导流，1 - 全额导流
     */
    private Integer guideType;

    /**
     * 如果为1 则不受交易金额及商户白名单限制
     */
    private Integer free;
}
