package cn.qg.qaplatform.encrypt.kdsp;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.util.Base64;

/**
 * kdsp
 * AES对称加密工具类
 */
public class AESUtil {
    private static final String CHAR_LIBRARY = "1234567890abcdefghijklmnopqrstuvwxyz";
    private static final int KEY_SIZE = 16;

    /**
     * 生成16位随机密钥
     *
     * @return
     */
    public static String getRandomKey() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < KEY_SIZE; i++) {
            int randomIdx = (int) (Math.random() * (CHAR_LIBRARY.length() - 1));
            result.append(CHAR_LIBRARY.charAt(randomIdx));
        }
        return result.toString();
    }

    // 加密
    public static String encryptToBase64(String sSrc, String sKey) throws Exception {
        if (sKey == null) {
//            System.out.print("Key为空null");
            return null;
        }
        // 判断Key是否为16位
        if (sKey.length() != 16) {
//            System.out.println(sKey);
//            System.out.print("Key长度不是16位");
            return null;
        }
        byte[] raw = sKey.getBytes();
        for (byte b : raw) {
//            System.out.println("======" + b);
        }
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance(ConfigureEncryptAndDecrypt.AES_ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, skeySpec,new IvParameterSpec(raw));
        byte[] encrypted = cipher.doFinal(sSrc.getBytes());
        // 此处使用BASE64做转码功能，同时能起到2次加密的作用。
        return new String(Base64.getEncoder().encode(encrypted));
    }

    // 解密
    public static String decryptFromBase64(String sSrc, String sKey) throws Exception {
        // 判断Key是否正确
        if (sKey == null) {
//            System.out.print("Key为空null");
            return null;
        }
//         判断Key是否为16位
        if (sKey.length() != 16) {
//            System.out.print("Key长度不是16位");
            return null;
        }
//		byte[] raw = sKey.getBytes(ConfigureEncryptAndDecrypt.CHAR_ENCODING);
        byte[] raw = sKey.getBytes();
//        byte[] raw = sKey.getBytes(ConfigureEncryptAndDecrypt.CHAR_ENCODING);
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance(ConfigureEncryptAndDecrypt.AES_ALGORITHM);
        cipher.init(Cipher.DECRYPT_MODE, skeySpec, new IvParameterSpec(raw));
        // 先用base64解密
        byte[] encrypted1 = Base64.getDecoder().decode(sSrc.getBytes());
        byte[] original = cipher.doFinal(encrypted1);
        return new String(original);
//        return new String(original, ConfigureEncryptAndDecrypt.CHAR_ENCODING);
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 100; i++) {
            System.out.println(getRandomKey());
        }

		/*
		 * 此处使用AES-128-ECB加密模式，key需要为16位。

		String cKey = "12345678901a3456";
		// 需要加密的字串
		String cSrc = "www.gowhere.so中文";
		System.out.println(cSrc);
		// 加密
		String enString = AES.encryptToBase64(cSrc, cKey);
		System.out.println("加密后的字串是：" + enString);

		// 解密
		String DeString = AES.decryptFromBase64(enString, cKey);
		System.out.println("解密后的字串是：" + DeString);*/
    }
}

