package cn.qg.qaplatform.entity.zdata;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 捞数据返回的享花卡用户实体类
 */
@Data
public class VccUserEntity {
    private String phoneNo;

    private String userId;

    private String uuid;

    /**
     * 注册渠道
     */
    private Long registeredFrom;

    /**
     * 过期时间
     */
    private Date nextApplyTime;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * CREATED("初始状态"), // 0
     * ACTIVATE_SUCC("激活成功"), // 1
     * ACTIVATE_FAILED("激活失败"), // 2
     * DISABLE("禁用"), // 3
     * AUTHING("审核中"), // 4
     * FREZE("冻结"), // 5
     * XYQB_OPEN_SUCC("信用钱包开户成功"), // 6
     * XYQB_OPEN_FAILED("信用钱包开户失败"), // 7
     */
    private Integer status;

    /**
     * 账号类别：vcc/scacard/xyqb_mall'
     */
    private String type;

    /**
     * 授信总额度
     */
    private BigDecimal riskAmount;

    /**
     * 剩余可用额度
     */
    private BigDecimal enableAmount;
}
