package cn.qg.qaplatform.controller;

import cn.qg.qaplatform.service.QueryLoanUserDataService;
import cn.qg.qaplatform.common.JsonResult;
import cn.qg.qaplatform.service.QueryBasicLoanStatusDataService;
import cn.qg.qaplatform.utils.page.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("query")
public class QueryLoanUserDataController {

    @Autowired
    private QueryBasicLoanStatusDataService basicLoanStatusDataService;

    @Autowired
    private QueryLoanUserDataService loanUserDataService;

    /**
     * @return 获取所有借款用户状态
     */
    @GetMapping("/getAllStatus")
    public JsonResult getLoanUserDataStatus() {
        List<Map<String, Object>> statusList = basicLoanStatusDataService.getAllUserLoanStatus();
        return JsonResult.success(statusList);
    }

    /**
     * @return 获取所有环境namespace
     */
    @GetMapping("/getAllEnv")
    public JsonResult getAllEnvInfo() {
        List<Map<String, Object>> envList = basicLoanStatusDataService.getAllEnvInfo();
        return JsonResult.success(envList);
    }

    /**
     * @param status 用户状态
     * @param pageNum
     * @param pageSize
     * @return 所有借款用户数据
     */
    @GetMapping("/loanUser")
    public JsonResult getLoanUserData(@RequestParam(value = "namespace") String namespace,
                                      @RequestParam(value = "status") Integer status,
                                      @RequestParam(value = "channel" ) Integer channel,
                                      @RequestParam(value = "fundId") Integer fundId,
                                      @RequestParam(defaultValue = "1") Integer pageNum,
                                      @RequestParam(defaultValue = "10") Integer pageSize) {
        PageResult result = loanUserDataService.getLoanUserData(namespace, status, channel, fundId, pageNum, pageSize);
        return JsonResult.success(result);
    }

    /**
     * 查看手机号是否存在
     * @param phone
     * @return
     */
    @GetMapping("/phoneExistence")
    public JsonResult checkPhoneExistence(@RequestParam(value = "namespace") String namespace,
                                          @RequestParam(value = "phone") String phone) {
        return JsonResult.success(basicLoanStatusDataService.queryIfPhoneExist(namespace, phone));
    }

    @GetMapping("/getUserInfoByPhoneNo")
    public JsonResult getUserInfoByPhoneNo(@RequestParam(value = "phoneNo") String phoneNo) {
        return null;
    }
}
