package cn.qg.qaplatform.service.zdata.xyqb;

import cn.qg.qaplatform.entity.zdata.XyqbApplyDataVo;
import cn.qg.qaplatform.entity.zdata.XjfqGenProcessVo;

import java.io.IOException;

public interface XyqbGenDataService {

    /**
     * 分配资金方
     */
    boolean assignFundCorp(String namespace, Integer fundId, String symbol) throws IOException;

    /**
     * 授信
     * @param xyqbApplyDataVo 造数据的相关信息
     * @return 成功或失败
     */
    boolean quotaAuth(XyqbApplyDataVo xyqbApplyDataVo, boolean auditResult) throws Exception;

    /**
     * 提现
     * @param xyqbApplyDataVo 造数据相关信息
     * @return 成功或失败
     */
    boolean withDraw(XyqbApplyDataVo xyqbApplyDataVo, boolean auditResult) throws Exception;

    /**
     * 放款
     * @param xyqbApplyDataVo
     * @return
     */
    boolean makeLoan(XyqbApplyDataVo xyqbApplyDataVo, boolean payStatus) throws Exception;

    /**
     * 造数据
     * @param xyqbApplyDataVo
     * @return
     * @throws Exception
     */
    boolean genLoanUser(XyqbApplyDataVo xyqbApplyDataVo) throws Exception;

    /**
     * 获取用户状态
     * @param namespace
     * @param phoneNo
     * @return
     */
    XjfqGenProcessVo queryUserStatus(String namespace, String phoneNo);

}
