package cn.quantgroup.qaplatform.service;

import cn.quantgroup.qaplatform.domain.LoanUser;

import java.util.List;
import java.util.Map;

/**
 * 单个状态数据查询
 */
public interface BasicLoanStatusDataService {
    /**
     * 获取所有的用户状态
     */
    List<Map<String, Object>> getAllUserLoanStatus();

    /**
     * 获取所有环境信息
     */
    List<Map<String, Object>> getAllEnvInfo();

    /**
     * 根据uuid获取用户信息
     */
    List<LoanUser> getUserDataListByUuidList(String namespace, List<String> uuidList);

    /**
     * 获取未申请用户
     * @return uuidList
     */
    List<String> getUnApplyUserUuidList(String namespace);

    /**
     * 判断用户是否存在
     */
    boolean queryIfPhoneExist(String namespace, String phone);

    /**
     * 获取审核状态的用户Id列表
     */
    List<String> getAuditStatusUserIdList(String namespace, Integer status);

    /**
     * 根据userIdList获取用户信息列表
     */
    List<LoanUser> getUserDataListByUserIdList(String namespace, List<String> userIdList);

    /**
     * 获取不同放款状态的用户
     */
    List<String> getLoanStatusUserIdList(String namespace, Integer status);

    /**
     * 获取多订单用户信息列表
     */
    List<String> getMultiOrderUserDataList(String namespace);
}
