package cn.quantgroup.qaplatform.service.impl;

import cn.quantgroup.qaplatform.common.SwitchDataSource;
import cn.quantgroup.qaplatform.common.enums.LoanStatus;
import cn.quantgroup.qaplatform.common.enums.Namespace;
import cn.quantgroup.qaplatform.dao.BasicLoanStatusDataMapper;
import cn.quantgroup.qaplatform.domain.LoanUser;
import cn.quantgroup.qaplatform.service.BasicLoanStatusDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class BasicLoanStatusDataServiceImpl implements BasicLoanStatusDataService {

    @Autowired
    BasicLoanStatusDataMapper basicLoanStatusDataMapper;
    /**
     * 获取所有用户状态
     * @return 用户状态列表
     */
    @Override
    public List<Map<String, Object>> getAllUserLoanStatus() {
        List<Map<String, Object>> allUserLoanStatusList = new ArrayList<>();
        for (LoanStatus loanStatus:LoanStatus.values()) {
            Map<String, Object> tempMap = new HashMap<>();
            tempMap.put("value", loanStatus.getStatus());
            tempMap.put("label", loanStatus.getDesc());
            allUserLoanStatusList.add(tempMap);
        }
        return allUserLoanStatusList;
    }

    /**
     * 获取所有环境信息
     * @return 环境信息列表
     */
    @Override
    public List<Map<String, Object>> getAllEnvInfo() {
        List<Map<String, Object>> allEnvList = new ArrayList<>();
        for (Namespace namespace: Namespace.values()) {
            Map<String, Object> tempMap = new HashMap<>();
            tempMap.put("value", namespace.getKey());
            tempMap.put("label", namespace.getDesc());
            allEnvList.add(tempMap);
        }
        return allEnvList;
    }

    /**
     * 根据uuidList获取用户信息
     * @param uuidList
     * @return
     */
    @Override
    public List<LoanUser> getUserDataListByUuidList(String namespace, List<String> uuidList) {
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb_user");
        return basicLoanStatusDataMapper.getUserDataListByUuidList(uuidList);
    }

    /**
     * 获取未申请用户uuidList
     * @return
     */
    @Override
    public List<String> getUnApplyUserUuidList(String namespace) {
        SwitchDataSource.dataSourceSwitch(namespace, "business_flow");
        return basicLoanStatusDataMapper.getUnApplyLoanUserUuidList();
    }

    /**
     * 查看手机号是否在库里
     * @param phone
     * @return
     */
    @Override
    public boolean queryIfPhoneExist(String namespace, String phone) {
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb_user");
        if (basicLoanStatusDataMapper.queryIfPhoneExist(phone) != null) {
            return true;
        }
        return false;
    }

    /**
     * 根据审核状态获取用户Id列表
     * @param namespace
     * @param status 0-审核中，1-审核成功，2-审核拒绝
     * @return
     */
    @Override
    public List<String> getAuditStatusUserIdList(String namespace, Integer status) {
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb");
        if (status == 0) {
            return basicLoanStatusDataMapper.getAuditStatusUserIdList(0);
        }
        if (status == 1) {
            return basicLoanStatusDataMapper.getAuditStatusUserIdList(2);
        }
        if (status == 2) {
            return basicLoanStatusDataMapper.getAuditStatusUserIdList(1);
        }
        return null;
    }

    /**
     * 根据userIdList获取用户信息列表
     *
     * @param userIdList
     * @return
     */
    @Override
    public List<LoanUser> getUserDataListByUserIdList(String namespace, List<String> userIdList) {
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb_user");
        List<LoanUser> result = basicLoanStatusDataMapper.getUserDataListByUserIdList(userIdList);
        return result;
    }

    /**
     * 获取不同放款状态的用户
     * @param namespace
     * @param status 0-放款中，1-放款成功，2-放款失败
     * @return
     */
    @Override
    public List<String> getLoanStatusUserIdList(String namespace, Integer status) {
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb");
        if (status == 0) {
            return basicLoanStatusDataMapper.getLoanStatusUserIdList(20);
        }
        if (status == 1) {
            return basicLoanStatusDataMapper.getLoanStatusUserIdList(15);
        }
        if (status == 2) {
            return basicLoanStatusDataMapper.getLoanStatusUserIdList(23);
        }
        return null;
    }

    /**
     * 获取多订单用户列表
     * @param namespace
     * @return
     */
    @Override
    public List<String> getMultiOrderUserDataList(String namespace) {
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb");
        return basicLoanStatusDataMapper.getMultiOrderUserIdList();
    }
}
