package cn.qg.qaplatform.service.xyqbUser.impl;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.entity.xyqbuser.User;
import cn.qg.qaplatform.mapper.xyqbUser.UserMapper;
import cn.qg.qaplatform.service.xyqbUser.UserService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl extends ServiceImpl<UserMapper, User> implements UserService {

    @Autowired
    UserMapper userMapper;

    @Override
    public User getUserInfoByPhoneNo(String namespace, String phoneNo) {
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb_user");
        QueryWrapper<User> userQueryWrapper = new QueryWrapper<>();
        userQueryWrapper.eq("phone_no", phoneNo);
        return userMapper.selectOne(userQueryWrapper);
    }
}
