package cn.qg.qaplatform.entity.vcc;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * vcc_quota.user_quota_record
 */
@Data
@TableName("user_quota_record")
public class UserQuotaRecord {
    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * uuid用户唯一编号
     */
    private String uuid;

    /**
     * userId用户ID
     */
    private Long userId;

    /**
     * 额度产品id
     */
    private Long productId;

    /**
     * 额度产品编码
     */
    private String productCode;

    /**
     * 渠道编号
     */
    private String channel;

    /**
     * 产品标记，A默认，B对照
     */
    private String mark;

    /**
     * 用户额度状态，1正常，2冻结，4永久冻结
     */
    private Integer status;

    /**
     * 授信额度，-9999不设置
     */
    private BigDecimal riskAmount;

    /**
     * 授信截止时间
     */
    private Date riskDeadline;

    /**
     * 激活额度，-9999不设置
     */
    private BigDecimal activatedAmount;

    /**
     * 待激活额度，-9999不设置
     */
    private BigDecimal unactivatedAmount;

    /**
     * 可用额度，-9999不设置
     */
    private BigDecimal enableAmount;

    /**
     * 已用额度
     */
    private BigDecimal usedAmount;

    /**
     * 预占用额度
     */
    private BigDecimal reserveAmount;

    /**
     * 冻结额度
     */
    private BigDecimal freezeAmount;

    /**
     * 可取现额度
     */
    private BigDecimal pocketAmount;

    /**
     * 已取现额度
     */
    private BigDecimal usedPocketAmount;

    /**
     * 金额验签
     */
    private String amountSign;

    /**
     * 版本号
     */
    private Long version;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 更新时间
     */
    private Date updatedAt;
}

