package cn.qg.qaplatform.zdata.controller.vcc;

import cn.qg.qaplatform.utils.JsonResult;
import cn.qg.qaplatform.zdata.entity.VccOpenResultVo;
import cn.qg.qaplatform.zdata.service.vcc.VccDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@CrossOrigin
@RestController
@RequestMapping("vcc")
@Api(tags = "vcc造数据")
public class VccGenController {

    @Autowired
    VccDataService vccDataService;

    @PostMapping("/gen")
    @ApiOperation(value = "vcc造数据")
    public JsonResult genVccUser(@RequestParam(value = "namespace") String namespace,
                                 @RequestParam(value = "phoneNo") String phoneNo,
                                 @RequestParam(value = "channel") String channel,
                                 @RequestParam(value = "status") Integer status) throws Exception {
        if (status !=1 && status !=2 && status !=3 && status !=4) {
            return JsonResult.clientFailed("状态值必须是1、2、3、4中的一个！");
        }
        if (!channel.equals("214") && !channel.equals("217")) {
            return JsonResult.clientFailed("渠道必须为214或217");
        }
        VccOpenResultVo result = vccDataService.makeVccUser(namespace, phoneNo, channel, status);
        if (result == null) {
            return JsonResult.serverFailed();
        }
        return JsonResult.success(result);
    }
}
