package cn.quantgroup.qaplatform.controller;

import cn.quantgroup.qaplatform.common.JsonResult;
import cn.quantgroup.qaplatform.service.QueryBasicLoanStatusDataService;
import cn.quantgroup.qaplatform.service.QueryLoanUserDataService;
import cn.quantgroup.qaplatform.utils.page.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

@CrossOrigin
@RestController
public class QueryLoanUserDataController {

    @Autowired
    private QueryBasicLoanStatusDataService basicLoanStatusDataService;

    @Autowired
    private QueryLoanUserDataService loanUserDataService;

    /**
     * @return 获取所有借款用户状态
     */
    @GetMapping("/allUserLoanStatus")
    public JsonResult getLoanUserDataStatus() {
        List<Map<String, Object>> statusList = basicLoanStatusDataService.getAllUserLoanStatus();
        return JsonResult.success(statusList);
    }

    /**
     * @return 获取所有环境namespace
     */
    @GetMapping("/allEnvInfo")
    public JsonResult getAllEnvInfo() {
        List<Map<String, Object>> envList = basicLoanStatusDataService.getAllEnvInfo();
        return JsonResult.success(envList);
    }

    /**
     * @param status 用户状态
     * @param pageNum
     * @param pageSize
     * @return 所有借款用户数据
     */
    @GetMapping("/getLoanUserData")
    public JsonResult getLoanUserData(@RequestParam(value = "namespace") String namespace,
                                      @RequestParam(value = "status") Integer status,
                                      @RequestParam(value = "channel" ) Integer channel,
                                      @RequestParam(value = "fundId") Integer fundId,
                                      @RequestParam(defaultValue = "1") Integer pageNum,
                                      @RequestParam(defaultValue = "10") Integer pageSize) {
        PageResult result = loanUserDataService.getLoanUserData(namespace, status, channel, fundId, pageNum, pageSize);
        return JsonResult.success(result);
    }

    /**
     * 查看手机号是否存在
     * @param phone
     * @return
     */
    @GetMapping("/checkPhoneExistence")
    public JsonResult checkPhoneExistence(@RequestParam(value = "namespace") String namespace,
                                          @RequestParam(value = "phone") String phone) {
        return JsonResult.success(basicLoanStatusDataService.queryIfPhoneExist(namespace, phone));
    }
}
