package cn.qg.qaplatform.automation.controller;

import cn.qg.qaplatform.automation.domain.Interface;
import cn.qg.qaplatform.automation.service.InterfaceService;
import cn.qg.qaplatform.common.JsonResult;
import cn.qg.qaplatform.common.SwitchDataSource;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/interface")
public class InterfaceController {
    @Autowired
    InterfaceService interfaceService;

    @GetMapping("/list")
    public JsonResult getInterfaceList(Integer projectId, Integer moduleId,
                                                        @RequestParam(defaultValue = "1") Integer pageNum,
                                                        @RequestParam(defaultValue = "10") Integer pageSize) {
        IPage<Interface> page = interfaceService.getInterfaceList(projectId, moduleId, pageNum, pageSize);
        Map<String, Object> map = new HashMap<>();
        map.put("list", page.getRecords());
        map.put("total", page.getTotal());
        return JsonResult.success(map);
    }

    @PostMapping("/add")
    public JsonResult<Boolean> addInterface(@RequestBody Interface entity) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(interfaceService.save(entity));
    }

    @PostMapping("/update")
    public JsonResult updateInterface(@RequestBody Interface entity) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(interfaceService.saveOrUpdate(entity));
    }

    @GetMapping("/delete")
    public JsonResult deleteInterface(Integer id) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(interfaceService.removeById(id));
    }
}
